/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.IntrospectionException;
import javax.management.MBeanFeatureInfo;
import org.jboss.mx.util.Serialization;

public class MBeanAttributeInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID;
    private String attributeType = null;
    private boolean isRead = false;
    private boolean isWrite = false;
    private boolean is = false;
    private transient String cacheString;
    private transient int cacheHashCode;

    public MBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs) throws IllegalArgumentException {
        super(name, description);
        if (isIs && !type.equals(Boolean.TYPE.getName()) && !type.equals(Boolean.class.getName())) {
            throw new IllegalArgumentException("Cannot have isIs for a non boolean/Boolean type");
        }
        this.attributeType = type;
        this.isRead = isReadable;
        this.isWrite = isWritable;
        this.is = isIs;
    }

    public MBeanAttributeInfo(String name, String description, Method getter, Method setter) throws IntrospectionException {
        super(name, description);
        if (getter != null) {
            if (getter.getParameterTypes().length != 0) {
                throw new IntrospectionException("Expecting getter method to be of the form 'AttributeType getAttributeName()': found getter with " + getter.getParameterTypes().length + " parameters.");
            }
            if (getter.getReturnType() == Void.TYPE) {
                throw new IntrospectionException("Expecting getter method to be of the form 'AttributeType getAttributeName()': found getter with void return type.");
            }
            this.isRead = true;
            if (getter.getName().startsWith("is")) {
                this.is = true;
            }
            this.attributeType = getter.getReturnType().getName();
        }
        if (setter != null) {
            if (setter.getParameterTypes().length != 1) {
                throw new IntrospectionException("Expecting the setter method to be of the form 'void setAttributeName(AttributeType value)': found setter with " + setter.getParameterTypes().length + " parameters.");
            }
            if (setter.getReturnType() != Void.TYPE) {
                throw new IntrospectionException("Expecting the setter method to be of the form 'void setAttributeName(AttributeType value)': found setter with " + setter.getReturnType() + " return type.");
            }
            this.isWrite = true;
            if (this.attributeType == null) {
                try {
                    this.attributeType = setter.getParameterTypes()[0].getName();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IntrospectionException("Attribute setter is lacking type: " + name);
                }
            }
            if (!this.attributeType.equals(setter.getParameterTypes()[0].getName())) {
                throw new IntrospectionException("Attribute type mismatch: " + name);
            }
        }
    }

    public synchronized Object clone() {
        MBeanAttributeInfo clone = null;
        try {
            clone = (MBeanAttributeInfo)super.clone();
            clone.attributeType = this.attributeType;
            clone.isRead = this.isRead;
            clone.isWrite = this.isWrite;
            clone.is = this.is;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String getType() {
        return this.attributeType;
    }

    public boolean isReadable() {
        return this.isRead;
    }

    public boolean isWritable() {
        return this.isWrite;
    }

    public boolean isIs() {
        return this.is;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof MBeanAttributeInfo)) {
            return false;
        }
        MBeanAttributeInfo other = (MBeanAttributeInfo)object;
        if (!super.equals(other)) {
            return false;
        }
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (this.isReadable() != other.isReadable()) {
            return false;
        }
        if (this.isWritable() != other.isWritable()) {
            return false;
        }
        return this.isIs() == other.isIs();
    }

    public int hashCode() {
        if (this.cacheHashCode == 0) {
            this.cacheHashCode = super.hashCode();
            this.cacheHashCode += this.getType().hashCode();
        }
        return this.cacheHashCode;
    }

    public String toString() {
        if (this.cacheString == null) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(this.getClass().getName()).append(":");
            buffer.append(" name=").append(this.getName());
            buffer.append(" description=").append(this.getDescription());
            buffer.append(" type=").append(this.getType());
            buffer.append(" Readable=").append(this.isReadable());
            buffer.append(" Writable=").append(this.isWritable());
            buffer.append(" isIs=").append(this.isIs());
            this.cacheString = buffer.toString();
        }
        return this.cacheString;
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = 7043855487133450673L;
                break;
            }
            default: {
                serialVersionUID = 8644704819898565848L;
            }
        }
    }
}

