/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import org.jboss.ejb3.ClientKernelAbstraction;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.JmxClientKernelAbstraction;
import org.jboss.ejb3.JmxKernelAbstraction;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;

public class KernelAbstractionFactory {
    private static final Logger log = Logger.getLogger(KernelAbstractionFactory.class);
    private static ClientKernelAbstraction clientKernelAbstraction = null;
    private static KernelAbstraction kernelAbstraction = null;

    public static KernelAbstraction getInstance() throws Exception {
        if (kernelAbstraction == null) {
            MBeanServer mbeanServer = (MBeanServer)KernelAbstractionFactory.getMBeanServer();
            kernelAbstraction = new JmxKernelAbstraction(mbeanServer);
        }
        return kernelAbstraction;
    }

    public static ClientKernelAbstraction getClientInstance() throws Exception {
        if (clientKernelAbstraction == null) {
            MBeanServerConnection mbeanServer = KernelAbstractionFactory.getMBeanServer();
            clientKernelAbstraction = new JmxClientKernelAbstraction(mbeanServer);
        }
        return clientKernelAbstraction;
    }

    protected static MBeanServerConnection getMBeanServer() throws Exception {
        MBeanServerConnection mbeanServer;
        try {
            mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (IllegalStateException e) {
            String adaptorName = System.getProperty("jbosstest.server.name", "jmx/invoker/RMIAdaptor");
            mbeanServer = (MBeanServerConnection)InitialContextFactory.getInitialContext().lookup(adaptorName);
        }
        return mbeanServer;
    }
}

