/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AuthTokenHandler
extends AbstractHandler {
    public static final String TAG_NAME = "authToken";
    private HandlerMaker maker = null;

    public AuthTokenHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        AuthToken obj = new AuthToken();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "authInfo");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("authInfo");
            obj.setAuthInfo((AuthInfo)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        AuthToken authToken = (AuthToken)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String generic = authToken.getGeneric();
        if (generic != null && generic.trim().length() > 0) {
            element.setAttribute("generic", generic);
            if (generic.equals("1.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api");
            } else if (generic.equals("2.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v2");
            } else if (generic.equals("3.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v3");
            }
        } else {
            element.setAttribute("generic", "2.0");
            element.setAttribute("xmlns", "urn:uddi-org:api_v2");
        }
        String operator = authToken.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        } else {
            element.setAttribute("operator", "");
        }
        AuthInfo authInfo = authToken.getAuthInfo();
        if (authInfo != null) {
            handler = this.maker.lookup("authInfo");
            handler.marshal(authInfo, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AuthToken object = new AuthToken();
        object.setAuthInfo(new AuthInfo("authToken:c9613c3c-fe55-4f34-a3da-b3167afbca4a"));
        object.setGeneric("2.0");
        object.setOperator("jUDDI.org");
        System.out.println();
        RegistryObject regObject = object;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

