/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.lock;

import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.util.PropertyConstants;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LockRequestEntity {
    private Log log = ExoLogger.getLogger((String)"jcr.LockRequestEntity");
    private QName lockScope;
    private QName lockType;
    private String owner;

    public LockRequestEntity(HierarchicalProperty input) {
        if (input == null) {
            this.lockScope = PropertyConstants.EXCLUSIVE;
            this.lockType = PropertyConstants.WRITE;
            return;
        }
        for (HierarchicalProperty prop : input.getChildren()) {
            if (prop.getName().equals(PropertyConstants.LOCKSCOPE)) {
                QName scope = prop.getChild(0).getName();
                if (!scope.equals(PropertyConstants.EXCLUSIVE)) {
                    this.log.warn((Object)("Lock is converted to exclusive scope, requested " + scope.getLocalPart()));
                }
                this.lockScope = PropertyConstants.EXCLUSIVE;
                continue;
            }
            if (prop.getName().equals(PropertyConstants.LOCKTYPE)) {
                QName type = prop.getChild(0).getName();
                if (!type.equals(PropertyConstants.WRITE)) {
                    this.log.warn((Object)("Lock is converted to exclusive scope, requested " + type.getLocalPart()));
                }
                this.lockScope = PropertyConstants.WRITE;
                continue;
            }
            if (!prop.getName().equals(PropertyConstants.OWNER) || prop.getChildren().size() <= 0) continue;
            this.owner = prop.getChild(0).getValue();
        }
    }

    public QName getLockScope() {
        return this.lockScope;
    }

    public String getOwner() {
        return this.owner;
    }

    public QName getLockType() {
        return this.lockType;
    }
}

