/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.ORB;
import org.omg.IOP.ServiceContext;

public class CodeSet {
    public static final int ISO8859_1 = 65537;
    public static final int UTF8 = 0x5010001;
    public static final int UTF16 = 65801;
    public static final String ISO8859_STR = "ISO8859_1";
    public static final String UTF8_STR = "UTF8";
    public static final String UTF16_STR = "UTF16";
    private static Logger logger = new NullLogger();
    private static boolean isConfigured = false;
    private static int nativeCodeSetChar = -1;
    private static int nativeCodeSetWchar = 65801;

    public static String csName(int n) {
        switch (n) {
            case 65537: {
                return ISO8859_STR;
            }
            case 65801: {
                return UTF16_STR;
            }
            case 0x5010001: {
                return UTF8_STR;
            }
        }
        return "Unknown TCS: " + Integer.toHexString(n);
    }

    public static synchronized void configure(Configuration configuration) throws ConfigurationException {
        if (!isConfigured) {
            int n;
            String string = configuration.getAttribute("jacorb.native_char_codeset", "");
            String string2 = configuration.getAttribute("jacorb.native_wchar_codeset", "");
            if (string != null && !"".equals(string)) {
                n = CodeSet.csInt(string);
                if (n != -1) {
                    nativeCodeSetChar = n;
                } else if (logger.isErrorEnabled()) {
                    logger.error("Cannot set default NCSC to " + string);
                }
            }
            if (string2 != null && !"".equals(string2)) {
                n = CodeSet.csInt(string2);
                if (n != -1) {
                    nativeCodeSetWchar = n;
                } else if (logger.isErrorEnabled()) {
                    logger.error("Cannot set default NCSW to " + string2);
                }
            }
            logger = configuration.getNamedLogger("org.jacorb.orb.codeset");
            isConfigured = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("CodeSet is already configured; further attempts to reconfigure will be ignored!");
        }
    }

    public static int csInt(String string) {
        try {
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = string.toUpperCase();
            if (string2.equals(ISO8859_STR)) {
                return 65537;
            }
            if (string2.equals(UTF8_STR)) {
                return 0x5010001;
            }
            if (string2.equals(UTF16_STR)) {
                return 65801;
            }
            return -1;
        }
    }

    public static int getTCSDefault() {
        if (nativeCodeSetChar == -1) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new ByteArrayOutputStream());
            String string = outputStreamWriter.getEncoding();
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string.equals(ISO8859_STR)) {
                nativeCodeSetChar = 65537;
            } else if (string.equals(UTF8_STR)) {
                nativeCodeSetChar = 0x5010001;
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("Warning - unknown codeset (" + string + ") - defaulting to ISO-8859-1");
                }
                nativeCodeSetChar = 65537;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("TCS set to " + CodeSet.csName(nativeCodeSetChar));
            }
        }
        return nativeCodeSetChar;
    }

    public static int getTCSWDefault() {
        return nativeCodeSetWchar;
    }

    public static int getConversionDefault() {
        return 0x5010001;
    }

    public static int selectTCS(CodeSetComponentInfo codeSetComponentInfo) {
        int n = CodeSet.selectCodeSet(codeSetComponentInfo.ForCharData, CodeSet.getTCSDefault());
        if (n == -1) {
            return CodeSet.selectCodeSet(codeSetComponentInfo.ForCharData, CodeSet.getConversionDefault());
        }
        return n;
    }

    public static int selectTCSW(CodeSetComponentInfo codeSetComponentInfo) {
        int n = CodeSet.selectCodeSet(codeSetComponentInfo.ForWcharData, CodeSet.getTCSWDefault());
        if (n == -1) {
            return CodeSet.selectCodeSet(codeSetComponentInfo.ForWcharData, CodeSet.getConversionDefault());
        }
        return n;
    }

    private static int selectCodeSet(CodeSetComponent codeSetComponent, int n) {
        if (codeSetComponent.native_code_set == n) {
            return n;
        }
        for (int i = 0; i < codeSetComponent.conversion_code_sets.length; ++i) {
            if (codeSetComponent.conversion_code_sets[i] != n) continue;
            return n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext createCodesetContext(int n, int n2) {
        CDROutputStream cDROutputStream = new CDROutputStream();
        try {
            cDROutputStream.beginEncapsulatedArray();
            CodeSetContextHelper.write(cDROutputStream, new CodeSetContext(n, n2));
            ServiceContext serviceContext = new ServiceContext(1, cDROutputStream.getBufferCopy());
            return serviceContext;
        }
        finally {
            cDROutputStream.close();
        }
    }

    public static CodeSetContext getCodeSetContext(ServiceContext[] serviceContextArray) {
        for (int i = 0; i < serviceContextArray.length; ++i) {
            if (serviceContextArray[i].context_id != 1) continue;
            CDRInputStream cDRInputStream = new CDRInputStream((ORB)null, serviceContextArray[i].context_data);
            cDRInputStream.openEncapsulatedArray();
            return CodeSetContextHelper.read(cDRInputStream);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0 && (stringArray[0].equals("-h") || !stringArray[0].equals("-a"))) {
            System.out.println("Usage: org.jacorb.orb.connection.CodeSet [-a]");
            System.exit(1);
        }
        Properties properties = System.getProperties();
        String string = (String)properties.get("os.name");
        System.out.println("Operating system name: " + string);
        System.out.println("Operating system version: " + properties.get("os.version"));
        System.out.println("Operating system architecture: " + properties.get("os.arch"));
        System.out.println("User region: " + System.getProperty("user.region"));
        System.out.println("JVM: " + properties.get("java.vm.version"));
        System.out.println("JacORB: 2.3.0 (JBoss patch 5), 06-Jun-2007");
        System.out.println("System file encoding property: " + System.getProperty("file.encoding"));
        String string2 = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        System.out.println("Cannonical encoding: " + string2);
        System.out.println("Default WChar encoding: " + CodeSet.csName(nativeCodeSetWchar));
        if (string.toLowerCase().indexOf("windows") == -1 && stringArray != null && stringArray.length == 1 && stringArray[0].equals("-a")) {
            String string3;
            BufferedReader bufferedReader;
            Process process;
            System.out.println("Locale is:");
            try {
                process = Runtime.getRuntime().exec("locale");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    System.out.println("    " + string3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println("Caught exception " + iOException);
            }
            System.out.println("All available locales are:");
            try {
                process = Runtime.getRuntime().exec("locale -a");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    System.out.println("        " + string3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println("Caught exception " + iOException);
            }
        }
    }
}

