/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jmx;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.jmx.StatisticsService;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.transaction.JBossTransactionManagerLookup;
import org.hibernate.transaction.JTATransactionFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.hibernate.ListenerInjector;
import org.jboss.hibernate.jmx.HibernateMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.naming.Util;

public class Hibernate
extends ServiceMBeanSupport
implements HibernateMBean {
    private static final Logger log = Logger.getLogger(Hibernate.class);
    public static final String SESSION_FACTORY_CREATE = "hibernate.sessionfactory.create";
    public static final String SESSION_FACTORY_DESTROY = "hibernate.sessionfactory.destroy";
    private String datasourceName;
    private String dialect;
    private String defaultSchema;
    private String defaultCatalog;
    private Boolean sqlCommentsEnabled;
    private Integer maxFetchDepth;
    private Integer jdbcFetchSize;
    private Integer jdbcBatchSize;
    private Boolean batchVersionedDataEnabled;
    private Boolean jdbcScrollableResultSetEnabled;
    private Boolean getGeneratedKeysEnabled;
    private Boolean streamsForBinaryEnabled;
    private String hbm2ddlAuto;
    private String querySubstitutions;
    private Boolean showSqlEnabled;
    private String username;
    private String password;
    private Boolean secondLevelCacheEnabled = Boolean.TRUE;
    private Boolean queryCacheEnabled;
    private String cacheProviderClass;
    private ObjectName deployedTreeCacheObjectName;
    private Boolean minimalPutsEnabled;
    private String cacheRegionPrefix;
    private Boolean structuredCacheEntriesEnabled;
    private Boolean statGenerationEnabled;
    private Boolean reflectionOptimizationEnabled;
    private String sessionFactoryName;
    private String sessionFactoryInterceptor;
    private String listenerInjector;
    private URL harUrl;
    private boolean scanForMappingsEnabled = false;
    private HashSet archiveClasspathUrls = new HashSet();
    private HashSet directoryClasspathUrls = new HashSet();
    private boolean dirty = false;
    private SessionFactory sessionFactory;
    private Date runningSince;
    private ObjectName hibernateStatisticsServiceName;

    protected void createService() throws Exception {
        log.trace((Object)"forcing bytecode provider -> javassist");
        System.setProperty("hibernate.bytecode.provider", "javassist");
    }

    public void startService() throws Exception {
        log.debug((Object)("Hibernate MBean starting; " + this));
        if (this.sessionFactory != null) {
            this.destroySessionFactory();
        }
        this.harUrl = this.determineHarUrl();
        if (this.harUrl != null) {
            log.trace((Object)"starting in har deployment mode");
            if (this.scanForMappingsEnabled) {
                log.trace((Object)"scan for mappings was enabled");
                this.scanForMappings();
            }
        } else {
            log.trace((Object)"starting in non-har deployment mode");
            this.scanForMappings();
        }
        this.buildSessionFactory();
    }

    public void stopService() throws Exception {
        this.destroySessionFactory();
        this.archiveClasspathUrls.clear();
        this.directoryClasspathUrls.clear();
    }

    private URL determineHarUrl() throws Exception {
        log.trace((Object)"Attempting to determine HarUrl...");
        DeploymentInfo deploymentInfo = this.getDeploymentInfo();
        if (deploymentInfo == null) {
            log.warn((Object)("Unable to locate deployment info [" + this.getServiceName() + "]"));
            return null;
        }
        String urlStr = deploymentInfo.url.getFile();
        log.trace((Object)("checking our deployment unit [" + urlStr + "]"));
        if (urlStr.endsWith(".har") || urlStr.endsWith(".har/")) {
            return deploymentInfo.url;
        }
        return null;
    }

    private final Configuration buildConfiguration() throws Exception {
        log.debug((Object)("Building SessionFactory; " + this));
        Configuration cfg = new Configuration();
        cfg.getProperties().clear();
        ListenerInjector listenerInjector = this.generateListenerInjectorInstance();
        if (listenerInjector != null) {
            listenerInjector.injectListeners(this.getServiceName(), cfg);
        }
        this.transferSettings(cfg.getProperties());
        this.handleMappings(cfg);
        Interceptor interceptorInstance = this.generateInterceptorInstance();
        if (interceptorInstance != null) {
            cfg.setInterceptor(interceptorInstance);
        }
        return cfg;
    }

    private void buildSessionFactory() throws Exception {
        Configuration cfg = this.buildConfiguration();
        this.sessionFactory = cfg.buildSessionFactory();
        try {
            if (this.sessionFactory.getStatistics() != null && this.sessionFactory.getStatistics().isStatisticsEnabled()) {
                String serviceName = this.getServiceName().toString();
                serviceName = serviceName.indexOf("type=service") != -1 ? serviceName.replaceAll("type=service", "type=stats") : serviceName + ",type=stats";
                this.hibernateStatisticsServiceName = new ObjectName(serviceName);
                StatisticsService hibernateStatisticsService = new StatisticsService();
                hibernateStatisticsService.setSessionFactory(this.sessionFactory);
                this.getServer().registerMBean(hibernateStatisticsService, this.hibernateStatisticsServiceName);
            }
            this.bind();
        }
        catch (Exception e) {
            this.forceCleanup();
            throw e;
        }
        this.dirty = false;
        this.sendNotification(new Notification(SESSION_FACTORY_CREATE, this.getServiceName(), this.getNextNotificationSequenceNumber()));
        this.runningSince = new Date();
        log.info((Object)("SessionFactory successfully built and bound into JNDI [" + this.sessionFactoryName + "]"));
    }

    private void destroySessionFactory() throws Exception {
        if (this.sessionFactory != null) {
            this.unbind();
            this.sessionFactory.close();
            this.sessionFactory = null;
            this.runningSince = null;
            if (this.hibernateStatisticsServiceName != null) {
                try {
                    this.getServer().unregisterMBean(this.hibernateStatisticsServiceName);
                }
                catch (Throwable t) {
                    log.warn((Object)"unable to cleanup statistics mbean", t);
                }
            }
            this.sendNotification(new Notification(SESSION_FACTORY_DESTROY, this.getServiceName(), this.getNextNotificationSequenceNumber()));
        }
    }

    private void handleMappings(Configuration cfg) {
        if (this.harUrl != null && !this.scanForMappingsEnabled) {
            File file = new File(this.harUrl.getFile());
            if (file.isDirectory()) {
                cfg.addDirectory(file);
            } else {
                cfg.addJar(file);
            }
        }
        for (File archive : this.archiveClasspathUrls) {
            log.debug((Object)("Passing archive [" + archive + "] to Hibernate Configration"));
            cfg.addJar(archive);
        }
        for (File directory : this.directoryClasspathUrls) {
            log.debug((Object)("Passing directory [" + directory + "] to Hibernate Configration"));
            cfg.addDirectory(directory);
        }
    }

    private void scanForMappings() throws DeploymentException {
        URL[] urls = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof RepositoryClassLoader) {
            urls = ((RepositoryClassLoader)cl).getClasspath();
        } else if (cl instanceof URLClassLoader) {
            urls = ((URLClassLoader)cl).getURLs();
        } else {
            throw new DeploymentException("Unable to determine urls from classloader [" + cl + "]");
        }
        for (int i = 0; i < urls.length; ++i) {
            File entry = new File(urls[i].getFile());
            log.trace((Object)("checking classpath entry [" + entry + "]"));
            if (!entry.exists()) continue;
            if (!entry.isDirectory()) {
                if (this.isArchive(entry)) {
                    log.trace((Object)"classpath entry was an archive file...");
                    this.archiveClasspathUrls.add(entry);
                    continue;
                }
                log.trace((Object)"classpath entry was a non-archive file...");
                continue;
            }
            log.trace((Object)"classpath entry was a directory...");
            this.directoryClasspathUrls.add(entry);
        }
    }

    private boolean isArchive(File file) {
        try {
            new JarFile(file);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void createSchema() throws Exception {
        new SchemaExport(this.buildConfiguration()).create(false, true);
    }

    public void dropSchema() throws Exception {
        new SchemaExport(this.buildConfiguration()).drop(false, true);
    }

    private void transferSettings(Properties settings) {
        String objNameString;
        if (this.cacheProviderClass == null) {
            this.cacheProviderClass = "org.hibernate.cache.HashtableCacheProvider";
        }
        log.debug((Object)("Using JDBC batch size : " + this.jdbcBatchSize));
        this.setUnlessNull(settings, "hibernate.connection.datasource", this.datasourceName);
        this.setUnlessNull(settings, "hibernate.dialect", this.dialect);
        this.setUnlessNull(settings, "hibernate.cache.provider_class", this.cacheProviderClass);
        this.setUnlessNull(settings, "hibernate.cache.region_prefix", this.cacheRegionPrefix);
        this.setUnlessNull(settings, "hibernate.cache.use_minimal_puts", this.minimalPutsEnabled);
        this.setUnlessNull(settings, "hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        this.setUnlessNull(settings, "hibernate.default_schema", this.defaultSchema);
        this.setUnlessNull(settings, "hibernate.jdbc.batch_size", this.jdbcBatchSize);
        this.setUnlessNull(settings, "hibernate.use_sql_comments", this.sqlCommentsEnabled);
        this.setUnlessNull(settings, "hibernate.jdbc.fetch_size", this.jdbcFetchSize);
        this.setUnlessNull(settings, "hibernate.jdbc.use_scrollable_resultset", this.jdbcScrollableResultSetEnabled);
        this.setUnlessNull(settings, "hibernate.cache.use_query_cache", this.queryCacheEnabled);
        this.setUnlessNull(settings, "hibernate.cache.use_structured_entries", this.structuredCacheEntriesEnabled);
        this.setUnlessNull(settings, "hibernate.query.substitutions", this.querySubstitutions);
        this.setUnlessNull(settings, "hibernate.max_fetch_depth", this.maxFetchDepth);
        this.setUnlessNull(settings, "hibernate.show_sql", this.showSqlEnabled);
        this.setUnlessNull(settings, "hibernate.jdbc.use_get_generated_keys", this.getGeneratedKeysEnabled);
        this.setUnlessNull(settings, "hibernate.connection.username", this.username);
        this.setUnlessNull(settings, "hibernate.connection.password", this.password);
        this.setUnlessNull(settings, "hibernate.jdbc.batch_versioned_data", this.batchVersionedDataEnabled);
        this.setUnlessNull(settings, "hibernate.jdbc.use_streams_for_binary", this.streamsForBinaryEnabled);
        this.setUnlessNull(settings, "hibernate.bytecode.use_reflection_optimizer", this.reflectionOptimizationEnabled);
        this.setUnlessNull(settings, "hibernate.generate_statistics", this.statGenerationEnabled);
        this.setUnlessNull(settings, "hibernate.transaction.manager_lookup_class", JBossTransactionManagerLookup.class.getName());
        this.setUnlessNull(settings, "hibernate.transaction.factory_class", JTATransactionFactory.class.getName());
        if (this.deployedTreeCacheObjectName != null && (objNameString = this.deployedTreeCacheObjectName.toString()) != null && !"".equals(objNameString)) {
            settings.setProperty("hibernate.treecache.objectName", objNameString);
        }
        settings.setProperty("hibernate.transaction.flush_before_completion", "true");
        settings.setProperty("hibernate.transaction.auto_close_session", "true");
        settings.setProperty("hibernate.connection.agressive_release", "true");
        settings.setProperty("hibernate.connection.release_mode", "after_statement");
    }

    private void setUnlessNull(Properties props, String key, Object value) {
        if (value != null) {
            props.setProperty(key, value.toString());
        }
    }

    private ListenerInjector generateListenerInjectorInstance() {
        if (this.listenerInjector == null) {
            return null;
        }
        log.info((Object)("attempting to use listener injector [" + this.listenerInjector + "]"));
        try {
            return (ListenerInjector)Thread.currentThread().getContextClassLoader().loadClass(this.listenerInjector).newInstance();
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to generate specified listener injector", t);
            return null;
        }
    }

    private Interceptor generateInterceptorInstance() {
        if (this.sessionFactoryInterceptor == null) {
            return null;
        }
        log.info((Object)("Generating session factory interceptor instance [" + this.sessionFactoryInterceptor + "]"));
        try {
            return (Interceptor)Thread.currentThread().getContextClassLoader().loadClass(this.sessionFactoryInterceptor).newInstance();
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to generate session factory interceptor instance", t);
            return null;
        }
    }

    private void bind() throws HibernateException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Util.bind((Context)ctx, (String)this.sessionFactoryName, (Object)this.sessionFactory);
        }
        catch (NamingException e) {
            throw new HibernateException("Unable to bind SessionFactory into JNDI", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    private void unbind() throws HibernateException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Util.unbind((Context)ctx, (String)this.sessionFactoryName);
        }
        catch (NamingException e) {
            throw new HibernateException("Unable to unbind SessionFactory from JNDI", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    private void forceCleanup() {
        try {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        return super.toString() + " [ServiceName=" + this.serviceName + ", JNDI=" + this.sessionFactoryName + "]";
    }

    public void rebuildSessionFactory() throws Exception {
        this.destroySessionFactory();
        this.buildSessionFactory();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSessionFactoryRunning() {
        return this.sessionFactory != null;
    }

    public String getVersion() {
        return "3.2.4.sp1";
    }

    public SessionFactory getInstance() {
        return this.sessionFactory;
    }

    public URL getHarUrl() {
        return this.harUrl;
    }

    public ObjectName getStatisticsServiceName() {
        return this.hibernateStatisticsServiceName;
    }

    public Date getRunningSince() {
        return this.runningSince;
    }

    public String getSessionFactoryName() {
        return this.sessionFactoryName;
    }

    public void setSessionFactoryName(String sessionFactoryName) {
        this.sessionFactoryName = sessionFactoryName;
        this.dirty = true;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
        this.dirty = true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.dirty = true;
    }

    public void setPassword(String password) {
        this.password = password;
        this.dirty = true;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        this.dirty = true;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public String getHbm2ddlAuto() {
        return this.hbm2ddlAuto;
    }

    public void setHbm2ddlAuto(String hbm2ddlAuto) {
        this.hbm2ddlAuto = hbm2ddlAuto;
        this.dirty = true;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
        this.dirty = true;
    }

    public Integer getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    public void setMaxFetchDepth(Integer maxFetchDepth) {
        this.maxFetchDepth = maxFetchDepth;
        this.dirty = true;
    }

    public Integer getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    public void setJdbcBatchSize(Integer jdbcBatchSize) {
        this.jdbcBatchSize = jdbcBatchSize;
        this.dirty = true;
    }

    public Integer getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    public void setJdbcFetchSize(Integer jdbcFetchSize) {
        this.jdbcFetchSize = jdbcFetchSize;
        this.dirty = true;
    }

    public Boolean getJdbcScrollableResultSetEnabled() {
        return this.jdbcScrollableResultSetEnabled;
    }

    public void setJdbcScrollableResultSetEnabled(Boolean jdbcScrollableResultSetEnabled) {
        this.jdbcScrollableResultSetEnabled = jdbcScrollableResultSetEnabled;
        this.dirty = true;
    }

    public Boolean getGetGeneratedKeysEnabled() {
        return this.getGeneratedKeysEnabled;
    }

    public void setGetGeneratedKeysEnabled(Boolean getGeneratedKeysEnabled) {
        this.getGeneratedKeysEnabled = getGeneratedKeysEnabled;
        this.dirty = true;
    }

    public String getQuerySubstitutions() {
        return this.querySubstitutions;
    }

    public void setQuerySubstitutions(String querySubstitutions) {
        this.querySubstitutions = querySubstitutions;
        this.dirty = true;
    }

    public Boolean getSecondLevelCacheEnabled() {
        return this.secondLevelCacheEnabled;
    }

    public void setSecondLevelCacheEnabled(Boolean secondLevelCacheEnabled) {
        this.secondLevelCacheEnabled = secondLevelCacheEnabled;
        this.dirty = true;
    }

    public Boolean getQueryCacheEnabled() {
        return this.queryCacheEnabled;
    }

    public void setQueryCacheEnabled(Boolean queryCacheEnabled) {
        this.queryCacheEnabled = queryCacheEnabled;
        this.dirty = true;
    }

    public String getCacheProviderClass() {
        return this.cacheProviderClass;
    }

    public void setCacheProviderClass(String cacheProviderClass) {
        this.cacheProviderClass = cacheProviderClass;
        this.dirty = true;
    }

    public String getCacheRegionPrefix() {
        return this.cacheRegionPrefix;
    }

    public void setCacheRegionPrefix(String cacheRegionPrefix) {
        this.cacheRegionPrefix = cacheRegionPrefix;
        this.dirty = true;
    }

    public Boolean getMinimalPutsEnabled() {
        return this.minimalPutsEnabled;
    }

    public void setMinimalPutsEnabled(Boolean minimalPutsEnabled) {
        this.minimalPutsEnabled = minimalPutsEnabled;
        this.dirty = true;
    }

    public Boolean getUseStructuredCacheEntriesEnabled() {
        return this.structuredCacheEntriesEnabled;
    }

    public void setUseStructuredCacheEntriesEnabled(Boolean structuredCacheEntriesEnabled) {
        this.structuredCacheEntriesEnabled = structuredCacheEntriesEnabled;
    }

    public Boolean getShowSqlEnabled() {
        return this.showSqlEnabled;
    }

    public void setShowSqlEnabled(Boolean showSqlEnabled) {
        this.showSqlEnabled = showSqlEnabled;
        this.dirty = true;
    }

    public Boolean getSqlCommentsEnabled() {
        return this.sqlCommentsEnabled;
    }

    public void setSqlCommentsEnabled(Boolean commentsEnabled) {
        this.sqlCommentsEnabled = commentsEnabled;
    }

    public String getSessionFactoryInterceptor() {
        return this.sessionFactoryInterceptor;
    }

    public void setSessionFactoryInterceptor(String sessionFactoryInterceptor) {
        this.sessionFactoryInterceptor = sessionFactoryInterceptor;
        this.dirty = true;
    }

    public String getListenerInjector() {
        return this.listenerInjector;
    }

    public void setListenerInjector(String listenerInjector) {
        this.listenerInjector = listenerInjector;
    }

    public ObjectName getDeployedTreeCacheObjectName() {
        return this.deployedTreeCacheObjectName;
    }

    public void setDeployedTreeCacheObjectName(ObjectName deployedTreeCacheObjectName) {
        this.deployedTreeCacheObjectName = deployedTreeCacheObjectName;
    }

    public Boolean getBatchVersionedDataEnabled() {
        return this.batchVersionedDataEnabled;
    }

    public void setBatchVersionedDataEnabled(Boolean batchVersionedDataEnabled) {
        this.batchVersionedDataEnabled = batchVersionedDataEnabled;
        this.dirty = true;
    }

    public Boolean getStreamsForBinaryEnabled() {
        return this.streamsForBinaryEnabled;
    }

    public void setStreamsForBinaryEnabled(Boolean streamsForBinaryEnabled) {
        this.streamsForBinaryEnabled = streamsForBinaryEnabled;
        this.dirty = true;
    }

    public Boolean getReflectionOptimizationEnabled() {
        return this.reflectionOptimizationEnabled;
    }

    public void setReflectionOptimizationEnabled(Boolean reflectionOptimizationEnabled) {
        this.reflectionOptimizationEnabled = reflectionOptimizationEnabled;
        this.dirty = true;
    }

    public Boolean getStatGenerationEnabled() {
        return this.statGenerationEnabled;
    }

    public void setStatGenerationEnabled(Boolean statGenerationEnabled) {
        this.statGenerationEnabled = statGenerationEnabled;
    }

    public boolean isScanForMappingsEnabled() {
        return this.scanForMappingsEnabled;
    }

    public void setScanForMappingsEnabled(boolean scanForMappingsEnabled) {
        this.scanForMappingsEnabled = scanForMappingsEnabled;
    }
}

