/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins;

import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.HttpLinkTreeAction;
import org.jboss.console.manager.interfaces.impl.MBeanResource;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNodeMenuEntryImpl;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;

public class EJBModuleLister
extends AbstractPluginWrapper {
    private static final long serialVersionUID = 4815998047707352041L;
    protected static final String JMX_JSR77_DOMAIN = "jboss.management.local";

    ResourceTreeNode[] createBeans(ObjectName parent) throws Exception {
        ObjectInstance[] insts = this.getMBeansForQuery("jboss.management.local:EJBModule=" + parent.getKeyProperty("name") + ",*", null);
        ResourceTreeNode[] ejbs = new ResourceTreeNode[insts.length];
        for (int i = 0; i < insts.length; ++i) {
            ObjectName objName = insts[i].getObjectName();
            String type = objName.getKeyProperty("j2eeType");
            String ejbName = objName.getKeyProperty("name");
            String containerName = this.createContainerName(objName);
            if (containerName == null) continue;
            containerName = this.encode(containerName);
            String containerUrl = "/jmx-console/HtmlAdaptor?action=inspectMBean&name=" + containerName;
            TreeNodeMenuEntry[] menus = new TreeNodeMenuEntry[]{new SimpleTreeNodeMenuEntryImpl("View container in other window", new HttpLinkTreeAction(containerUrl, "_blank"))};
            String j2eeType = objName.getKeyProperty("j2eeType");
            String filename = "EJB.jsp";
            if (j2eeType.equalsIgnoreCase("StatelessSessionBean")) {
                filename = "StatelessEjb.jsp";
            } else if (j2eeType.equalsIgnoreCase("StatefulSessionBean")) {
                filename = "StatefulEjb.jsp";
            } else if (j2eeType.equalsIgnoreCase("EntityBean")) {
                filename = "EntityEjb.jsp";
            } else if (j2eeType.equalsIgnoreCase("MessageDrivenBean")) {
                filename = "MdbEjb.jsp";
            }
            ejbs[i] = this.createResourceNode(ejbName, type, "images/bean.gif", filename + "?ObjectName=" + this.encode(objName.toString()) + "&ContainerObjectName=" + containerName, menus, null, null, objName.toString(), insts[i].getClassName());
        }
        return ejbs;
    }

    protected String createContainerName(ObjectName objName) throws Exception {
        String jndiName = (String)this.mbeanServer.getAttribute(objName, "JndiName");
        String localJndiName = (String)this.mbeanServer.getAttribute(objName, "LocalJndiName");
        String containerUrl = null;
        String defaultContainerUrl = "jboss.j2ee:service=EJB,jndiName=" + jndiName;
        ObjectName defaultObjectName = new ObjectName(defaultContainerUrl);
        String localContainerUrl = "jboss.j2ee:service=EJB,jndiName=" + localJndiName;
        ObjectName localObjectName = new ObjectName(localContainerUrl);
        if (this.mbeanServer.isRegistered(defaultObjectName)) {
            this.log.debug("Found container with default JNDI name URL for - " + objName.toString());
            containerUrl = defaultContainerUrl;
        } else if (this.mbeanServer.isRegistered(localObjectName)) {
            this.log.debug("Found container with local JNDI name URL for - " + objName.toString());
            containerUrl = localContainerUrl;
        } else {
            this.log.warn("Unable to find container for - " + objName.toString());
        }
        return containerUrl;
    }

    protected TreeNode getTreeForResource(String profile, ManageableResource resource) {
        try {
            ObjectName objName = ((MBeanResource)resource).getObjectName();
            return this.createTreeNode(objName.getKeyProperty("name"), "", "images/beans.gif", "EJBModule.jsp?ObjectName=" + this.encode(objName.toString()), null, null, this.createBeans(objName)).setMasterNode(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(this.checker);
            return null;
        }
    }
}

