/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public final class TCK14ToJunitReportConverter {
    private static final FileFilter filter = new TCKReportFileFilter();
    private static File junitReportDir = null;

    public static void main(String[] args) throws IOException {
        File[] files;
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        File tckReportDir = new File(args[0]);
        junitReportDir = new File(args[1]);
        if (!tckReportDir.exists() && !tckReportDir.isDirectory()) {
            throw new IllegalArgumentException("TCK report directory '" + tckReportDir.getAbsolutePath() + "' doesn't exist or is not directory");
        }
        if (!junitReportDir.mkdir() || !junitReportDir.exists() && !junitReportDir.isDirectory()) {
            throw new IllegalArgumentException("JUnit report Directory '" + junitReportDir.getAbsolutePath() + "' doesn't exist or is not directory");
        }
        for (File f : files = tckReportDir.listFiles(filter)) {
            if (f.isDirectory()) {
                TCK14ToJunitReportConverter.convertDirectory("", f);
                continue;
            }
            TCK14ToJunitReportConverter.convertFile("", f);
        }
    }

    private static void convertDirectory(String pckg, File dir) throws IOException {
        File[] files;
        for (File f : files = dir.listFiles(filter)) {
            if (f.isDirectory()) {
                TCK14ToJunitReportConverter.convertDirectory((pckg.length() == 0 ? "" : pckg + "/") + f.getName(), f);
                continue;
            }
            TCK14ToJunitReportConverter.convertFile(pckg, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertFile(String pckg, File f) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringBuilder sb = new StringBuilder();
        boolean testPassed = false;
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.trim().length() > 0 && testPassed) {
                    testPassed = false;
                }
                sb.append(line);
                sb.append("\n");
                if (line.indexOf("test result: Passed") != -1) {
                    testPassed = true;
                }
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        TCK14ToJunitReportConverter.createJunitReport(sb.toString(), testPassed, pckg, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createJunitReport(String consoleOutput, boolean passed, String pckg, File file) throws IOException {
        String fileName = file.getName().substring(0, file.getName().length() - 4);
        StringBuilder sb = new StringBuilder();
        String nl = "\n";
        sb.append("<?xml version='1.0' encoding='UTF-8'?>" + nl);
        sb.append("<testsuite errors='0' failures='" + (passed ? 0 : 1) + "' name='" + pckg.replace('/', '.') + "." + fileName + "' tests='1' time='1'>" + nl);
        sb.append("  <properties/>" + nl);
        sb.append("  <testcase classname='" + pckg.replace('/', '.') + "' name='" + fileName + "' time='1'/>" + nl);
        sb.append("  <system-out><![CDATA[" + TCK14ToJunitReportConverter.replace("]]>", "] ]>", consoleOutput) + "]]></system-out>" + nl);
        sb.append("  <system-err><![CDATA[]]></system-err>" + nl);
        sb.append("</testsuite>" + nl);
        File junitReportFile = new File(junitReportDir, "TEST-" + pckg.replace('/', '.') + "." + fileName + ".xml");
        System.out.println("Creating JUnit report file: " + junitReportFile.getAbsolutePath());
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(junitReportFile);
            os.write(sb.toString().getBytes());
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private static String replace(String oldString, String newString, String data) {
        int fromIndex = 0;
        int index = 0;
        StringBuilder result = new StringBuilder();
        while ((index = data.indexOf(oldString, fromIndex)) >= 0) {
            result.append(data.substring(fromIndex, index));
            result.append(newString);
            fromIndex = index + oldString.length();
        }
        result.append(data.substring(fromIndex));
        return result.toString();
    }

    private static final class TCKReportFileFilter
    implements FileFilter {
        private TCKReportFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() ? true : f.getName().endsWith(".jtr");
        }
    }
}

