/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.text;

import org.gatein.common.util.ParameterValidation;

public class TextTools {
    public static boolean isAlphaNumeric(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static char toHex(int z) throws IllegalArgumentException {
        if (z >= 0 && z < 10) {
            return (char)(48 + z);
        }
        if (z >= 10 && z < 16) {
            return (char)(55 + z);
        }
        throw new IllegalArgumentException("Wrong character");
    }

    public static String replace(String string, String pattern, String replacement) {
        StringBuffer buffer = new StringBuffer(string.length());
        int previous = 0;
        int current = string.indexOf(pattern);
        while (current != -1) {
            buffer.append(string.substring(previous, current));
            buffer.append(replacement);
            previous = current + pattern.length();
            current = string.indexOf(pattern, previous);
        }
        buffer.append(string.substring(previous));
        return buffer.toString();
    }

    public static String replaceAllInstancesOfBoundedString(String initial, String prefix, String suffix, String replacement) {
        return TextTools.replaceBoundedString(initial, prefix, suffix, replacement, true, false);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, String replacement, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries) {
        ParameterValidation.throwIllegalArgExceptionIfNull(replacement, "replacement");
        return TextTools.replaceBoundedString(initial, prefix, suffix, new ConstantStringReplacementGenerator(replacement), replaceIfBoundedStringEmpty, keepBoundaries);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, StringReplacementGenerator generator, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries) {
        if (ParameterValidation.isNullOrEmpty(initial)) {
            return initial;
        }
        ParameterValidation.throwIllegalArgExceptionIfNull(generator, "StringReplacementGenerator");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(prefix, "prefix", "Tools.replaceBoundedString");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(suffix, "suffix", "Tools.replaceBoundedString");
        StringBuffer tmp = new StringBuffer(initial);
        int prefixIndex = tmp.indexOf(prefix);
        int suffixLength = suffix.length();
        int prefixLength = prefix.length();
        while (prefixIndex != -1) {
            int suffixIndex = tmp.indexOf(suffix, prefixIndex);
            if (suffixIndex != -1 && (replaceIfBoundedStringEmpty || suffixIndex != prefixIndex + prefixLength)) {
                String match;
                if (keepBoundaries) {
                    match = tmp.substring(prefixIndex + prefixLength, suffixIndex);
                    tmp.delete(prefixIndex + prefixLength, suffixIndex);
                    tmp.insert(prefixIndex + prefixLength, generator.getReplacementFor(match));
                } else {
                    match = tmp.substring(prefixIndex, suffixIndex + suffixLength);
                    tmp.delete(prefixIndex, suffixIndex + suffixLength);
                    tmp.insert(prefixIndex, generator.getReplacementFor(match));
                }
            }
            prefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength);
        }
        return tmp.toString();
    }

    public static class ConstantStringReplacementGenerator
    implements StringReplacementGenerator {
        private String replacement;

        public ConstantStringReplacementGenerator(String replacement) {
            this.replacement = replacement;
        }

        public String getReplacementFor(String match) {
            return this.replacement;
        }
    }

    public static interface StringReplacementGenerator {
        public String getReplacementFor(String var1);
    }
}

