/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.services.jcr.access.SystemIdentity;

public class LockData {
    private long birthday;
    private final boolean deep;
    private boolean live;
    private final Set<String> lockHolders = new HashSet<String>();
    private String lockToken;
    private String nodeIdentifier;
    private String owner;
    private final boolean sessionScoped;
    private long timeOut;

    public LockData(String nodeIdentifier, String lockToken, boolean deep, boolean sessionScoped, String owner, long timeOut) {
        this.nodeIdentifier = nodeIdentifier;
        this.lockToken = lockToken;
        this.deep = deep;
        this.sessionScoped = sessionScoped;
        this.owner = owner;
        this.timeOut = timeOut;
        this.live = true;
        this.birthday = System.currentTimeMillis();
    }

    public boolean addLockHolder(String sessionId) {
        return this.lockHolders.add(sessionId);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof LockData) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int getLockHolderSize() {
        return this.lockHolders.size();
    }

    public String getLockToken(String sessionId) {
        if (this.isLockHolder(sessionId)) {
            return this.lockToken;
        }
        return null;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getTimeToDeath() {
        return this.birthday + this.timeOut - System.currentTimeMillis();
    }

    public int hashCode() {
        return super.hashCode() + this.lockToken.hashCode();
    }

    public boolean isDeep() {
        return this.deep;
    }

    public boolean isLive() {
        return this.live;
    }

    public boolean isLockHolder(String sessionId) {
        return this.lockHolders.contains(sessionId) || SystemIdentity.SYSTEM.equals(sessionId);
    }

    public boolean isSessionScoped() {
        return this.sessionScoped;
    }

    public void refresh() {
        this.birthday = System.currentTimeMillis();
    }

    public boolean removeLockHolder(String sessionId) {
        return this.lockHolders.remove(sessionId);
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public void setLockToken(String lockToken) {
        this.lockToken = lockToken;
    }

    public void setNodeIdentifier(String nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    protected long getTimeOut() {
        return this.timeOut;
    }

    protected void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }
}

