/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.oauth.client.OAuthResponseMessage;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpMethodResponse
extends OAuthResponseMessage {
    private final HttpMethod method;
    private String bodyAsString = null;

    public HttpMethodResponse(HttpMethod method) throws IOException {
        super(method.getName(), method.getURI().toString());
        this.method = method;
        Header[] headerArray = method.getResponseHeaders("WWW-Authenticate");
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            this.decodeWWWAuthenticate(header.getValue());
            ++n2;
        }
    }

    @Override
    public InputStream getBodyAsStream() throws IOException {
        if (this.bodyAsString == null) {
            return this.method.getResponseBodyAsStream();
        }
        return super.getBodyAsStream();
    }

    @Override
    public String getBodyAsString() throws IOException {
        if (this.bodyAsString == null) {
            this.bodyAsString = this.method.getResponseBodyAsString();
        }
        return this.bodyAsString;
    }

    @Override
    protected void dump(Map<String, Object> into) throws IOException {
        super.dump(into);
        StringBuilder request = new StringBuilder(this.method.getName());
        request.append(" ").append(this.method.getPath());
        String query = this.method.getQueryString();
        if (query != null && query.length() > 0) {
            request.append("?").append(query);
        }
        request.append("\n");
        Header[] headerArray = this.method.getRequestHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            request.append(header.getName()).append(": ").append(header.getValue()).append("\n");
            ++n2;
        }
        into.put("HTTP request headers", request.toString());
        into.put("HTTP status", new Integer(this.method.getStatusCode()));
        StringBuilder response = new StringBuilder(this.method.getStatusLine().toString());
        response.append("\n");
        Header[] headerArray2 = this.method.getResponseHeaders();
        n2 = headerArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            Header header = headerArray2[n3];
            response.append(header.getName()).append(": ").append(header.getValue()).append("\n");
            ++n3;
        }
        String body = this.getBodyAsString();
        if (body != null) {
            response.append("\n");
            response.append(body);
        }
        into.put("HTTP response", response.toString());
    }
}

