/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ReadOnlyWorkspaceException;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class TxIsolatedOperation {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.TxIsolatedOperation");
    protected final TransactionManager txManager;
    protected static final ThreadLocal<Transaction> currentIsolated = new ThreadLocal();

    public TxIsolatedOperation(TransactionManager txManager) {
        this.txManager = txManager;
    }

    protected abstract void action() throws RepositoryException;

    protected void beginTx() throws NotSupportedException, SystemException {
        this.txManager.begin();
    }

    protected void commitTx() throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.txManager.commit();
    }

    protected void rollbackTx() throws NotSupportedException, SystemException {
        this.txManager.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void txAction() throws RepositoryException {
        block19: {
            boolean actInTx;
            boolean bl = actInTx = currentIsolated.get() == null;
            if (actInTx) {
                boolean rollback = true;
                try {
                    try {
                        block18: {
                            this.beginTx();
                            Transaction current = this.txManager.getTransaction();
                            if (current != null) {
                                currentIsolated.set(current);
                            }
                            this.action();
                            try {
                                try {
                                    this.commitTx();
                                }
                                catch (RollbackException e) {
                                    LOG.error((Object)"Transaction has been rolled back", (Throwable)e);
                                    Object var6_7 = null;
                                    rollback = false;
                                    break block18;
                                }
                                catch (HeuristicRollbackException e) {
                                    LOG.error((Object)"Relevant updates have been rolled back", (Throwable)e);
                                    Object var6_8 = null;
                                    rollback = false;
                                    break block18;
                                }
                                catch (HeuristicMixedException e) {
                                    LOG.error((Object)"Some relevant updates have been committed and others have been rolled back", (Throwable)e);
                                    Object var6_9 = null;
                                    rollback = false;
                                    break block18;
                                }
                                catch (IllegalStateException e) {
                                    LOG.error((Object)"Commit impossible, thread is not associated with the transaction", (Throwable)e);
                                    Object var6_10 = null;
                                    rollback = false;
                                    break block18;
                                }
                                catch (SecurityException e) {
                                    LOG.error((Object)"Commit impossible, thread is not allowed to commit the transaction", (Throwable)e);
                                    Object var6_11 = null;
                                    rollback = false;
                                    break block18;
                                }
                                catch (SystemException e) {
                                    LOG.error((Object)"Commit impossible dur to unexpected XA error", (Throwable)e);
                                    Object var6_12 = null;
                                    rollback = false;
                                }
                                Object var6_6 = null;
                                rollback = false;
                            }
                            catch (Throwable throwable) {
                                Object var6_13 = null;
                                rollback = false;
                                throw throwable;
                            }
                        }
                        Object var8_21 = null;
                        if (rollback) {
                            this.doRollback();
                        }
                        currentIsolated.remove();
                        break block19;
                    }
                    catch (NotSupportedException e) {
                        rollback = false;
                        this.doRollback();
                        throw new RepositoryException((Throwable)e);
                    }
                    catch (SystemException e) {
                        rollback = false;
                        this.doRollback();
                        throw new RepositoryException("Unexpected error on begin or get of a transaction", (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_22 = null;
                    if (rollback) {
                        this.doRollback();
                    }
                    currentIsolated.remove();
                    throw throwable;
                }
            }
            this.action();
        }
    }

    private void doRollback() {
        try {
            this.rollbackTx();
        }
        catch (Exception e1) {
            LOG.error((Object)"Rollback error ", (Throwable)e1);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform() throws RepositoryException {
        try {
            Transaction current = this.txManager.suspend();
            Object var2_3 = null;
            this.txAction();
            Object var5_10 = null;
            if (current == null) return;
            try {
                this.txManager.resume(current);
                return;
            }
            catch (InvalidTransactionException e) {
                if (var2_3 == null) {
                    throw new RepositoryException("Error of Transaction resume", (Throwable)e);
                }
                LOG.error((Object)"Error of Transaction resume", (Throwable)e);
                return;
            }
            catch (IllegalStateException e) {
                if (var2_3 == null) {
                    throw new RepositoryException("Error of Transaction resume", (Throwable)e);
                }
                LOG.error((Object)"Error of Transaction resume", (Throwable)e);
                return;
            }
            catch (SystemException e) {
                if (var2_3 == null) {
                    throw new RepositoryException("Error of Transaction resume", (Throwable)e);
                }
                LOG.error((Object)"Error of Transaction resume", (Throwable)e);
            }
            return;
            {
                catch (JCRInvalidItemStateException e) {
                    JCRInvalidItemStateException jCRInvalidItemStateException = e;
                    throw new JCRInvalidItemStateException(e.getMessage(), e.getIdentifier(), e.getState(), (Throwable)((Object)jCRInvalidItemStateException));
                }
                catch (InvalidItemStateException e) {
                    InvalidItemStateException invalidItemStateException = e;
                    throw new InvalidItemStateException((Throwable)invalidItemStateException);
                }
                catch (ItemExistsException e) {
                    ItemExistsException itemExistsException = e;
                    throw new ItemExistsException((Throwable)itemExistsException);
                }
                catch (ReadOnlyWorkspaceException e) {
                    ReadOnlyWorkspaceException readOnlyWorkspaceException = e;
                    throw new ReadOnlyWorkspaceException((Throwable)((Object)readOnlyWorkspaceException));
                }
                catch (RepositoryException e) {
                    RepositoryException repositoryException = e;
                    throw new RepositoryException((Throwable)repositoryException);
                }
                catch (Throwable e) {
                    Throwable throwable = e;
                    throw new RepositoryException(throwable);
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                if (current == null) throw throwable;
                try {
                    this.txManager.resume(current);
                    throw throwable;
                }
                catch (InvalidTransactionException e) {
                    if (var2_3 == null) {
                        throw new RepositoryException("Error of Transaction resume", (Throwable)e);
                    }
                    LOG.error((Object)"Error of Transaction resume", (Throwable)e);
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    if (var2_3 == null) {
                        throw new RepositoryException("Error of Transaction resume", (Throwable)e);
                    }
                    LOG.error((Object)"Error of Transaction resume", (Throwable)e);
                    throw throwable;
                }
                catch (SystemException e) {
                    if (var2_3 == null) {
                        throw new RepositoryException("Error of Transaction resume", (Throwable)e);
                    }
                    LOG.error((Object)"Error of Transaction resume", (Throwable)e);
                }
                throw throwable;
            }
        }
        catch (SystemException e) {
            throw new RepositoryException("Error of Transaction suspend", (Throwable)e);
        }
    }
}

