/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.util.NodeTypeRecognizer;
import org.exoplatform.services.jcr.impl.xml.importing.BaseXmlImporter;
import org.exoplatform.services.jcr.impl.xml.importing.ContentImporter;
import org.exoplatform.services.jcr.impl.xml.importing.DocumentViewImporter;
import org.exoplatform.services.jcr.impl.xml.importing.SystemViewImporter;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeutralImporter
extends BaseXmlImporter {
    private ContentImporter contentImporter = null;

    public NeutralImporter(NodeData parent, QPath ancestorToSave, int uuidBehavior, ItemDataConsumer dataConsumer, NodeTypeDataManager ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        super(parent, ancestorToSave, uuidBehavior, dataConsumer, ntManager, locationFactory, valueFactory, namespaceRegistry, accessManager, userState, context, repository, currentWorkspaceName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws RepositoryException {
        if (this.contentImporter == null) {
            throw new IllegalStateException("StartElement must be  call first");
        }
        this.contentImporter.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws RepositoryException {
        if (this.contentImporter == null) {
            throw new IllegalStateException("StartElement must be call first");
        }
        this.contentImporter.endElement(uri, localName, qName);
    }

    @Override
    public PlainChangesLog getChanges() {
        if (this.contentImporter != null) {
            return this.contentImporter.getChanges();
        }
        return super.getChanges();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String name, Map<String, String> atts) throws RepositoryException {
        if (this.contentImporter == null) {
            switch (NodeTypeRecognizer.recognize(namespaceURI, name)) {
                case DOCVIEW: {
                    this.contentImporter = new DocumentViewImporter(this.getParent(), this.ancestorToSave, this.uuidBehavior, this.dataConsumer, this.nodeTypeDataManager, this.locationFactory, this.valueFactory, this.namespaceRegistry, this.accessManager, this.userState, this.context, this.repository, this.currentWorkspaceName);
                    break;
                }
                case SYSVIEW: {
                    this.contentImporter = new SystemViewImporter(this.getParent(), this.ancestorToSave, this.uuidBehavior, this.dataConsumer, this.nodeTypeDataManager, this.locationFactory, this.valueFactory, this.namespaceRegistry, this.accessManager, this.userState, this.context, this.repository, this.currentWorkspaceName);
                    break;
                }
                default: {
                    throw new IllegalStateException("There was an error during ascertaining the type of document. First element " + namespaceURI + ":" + name);
                }
            }
        }
        this.contentImporter.startElement(namespaceURI, localName, name, atts);
    }
}

