/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.command;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.chain.Context;
import org.exoplatform.services.ftp.FtpContext;
import org.exoplatform.services.ftp.client.FtpClientSession;
import org.exoplatform.services.ftp.command.FtpCommand;
import org.exoplatform.services.ftp.listcode.FtpFileInfo;
import org.exoplatform.services.ftp.listcode.FtpFileInfoImpl;
import org.exoplatform.services.ftp.listcode.FtpSystemCoder;
import org.exoplatform.services.ftp.listcode.FtpSystemCoderManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FtpCommandImpl
implements FtpCommand {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ftp.FtpCommandImpl");
    protected boolean isNeedLogin = true;
    protected String commandName = "";
    public ThreadLocal<FtpClientSession> localClientSession = new ThreadLocal();

    public void reply(String replyString) throws IOException {
        this.clientSession().reply(replyString);
    }

    @Override
    public boolean execute(Context context) throws Exception {
        this.localClientSession.set(((FtpContext)context).getFtpClientSession());
        if (this.isNeedLogin && !this.clientSession().isLogged()) {
            this.reply("530 Please login with USER and PASS");
            return false;
        }
        String[] params = ((FtpContext)context).getParams();
        this.run(params);
        String cmdParams = null;
        if (params.length > 1) {
            cmdParams = params[1];
        }
        this.clientSession().setPrevCommand(this.commandName);
        this.clientSession().setPrevParams(cmdParams);
        return true;
    }

    @Override
    public abstract void run(String[] var1) throws Exception;

    @Override
    public FtpClientSession clientSession() {
        return this.localClientSession.get();
    }

    public ArrayList<FtpFileInfo> getFileList(String resPath) {
        ArrayList<FtpFileInfo> files = new ArrayList<FtpFileInfo>();
        FtpFileInfoImpl fi = new FtpFileInfoImpl();
        fi.setName(".");
        files.add(fi);
        fi = new FtpFileInfoImpl();
        fi.setName("..");
        files.add(fi);
        ArrayList<String> newPath = this.clientSession().getFullPath(resPath);
        try {
            if (newPath.size() == 0) {
                String[] workspaces = this.clientSession().getFtpServer().getRepository().getWorkspaceNames();
                for (int i = 0; i < workspaces.length; ++i) {
                    FtpFileInfoImpl fileInfo = new FtpFileInfoImpl();
                    fileInfo.setName(workspaces[i]);
                    files.add(fileInfo);
                }
            } else {
                String repoPath = this.clientSession().getRepoPath(newPath);
                Session curSession = this.clientSession().getSession(newPath.get(0));
                Node parentNode = (Node)curSession.getItem(repoPath);
                if (parentNode.isNodeType("nt:file")) {
                    files.clear();
                    FtpFileInfoImpl fileInfo = new FtpFileInfoImpl();
                    fileInfo.initFromNode(parentNode);
                    files.add(fileInfo);
                } else {
                    NodeIterator nodeIter = parentNode.getNodes();
                    while (nodeIter.hasNext()) {
                        Node curNode = nodeIter.nextNode();
                        FtpFileInfoImpl fileInfo = new FtpFileInfoImpl();
                        fileInfo.initFromNode(curNode);
                        files.add(fileInfo);
                    }
                }
            }
        }
        catch (RepositoryException rexc) {
            return null;
        }
        catch (Exception exc) {
            log.info("Unhandled exception. " + exc.getMessage(), exc);
            return null;
        }
        return files;
    }

    public void removeResource(String resName) throws IOException {
        try {
            ArrayList<String> newPath = this.clientSession().getFullPath(resName);
            Session curSession = this.clientSession().getSession(newPath.get(0));
            String repoPath = this.clientSession().getRepoPath(newPath);
            Node parentNode = (Node)curSession.getItem(repoPath);
            parentNode.remove();
            curSession.save();
            this.reply(String.format("250 %s command successful", this.commandName));
            return;
        }
        catch (PathNotFoundException pexc) {
        }
        catch (NoSuchWorkspaceException wexc) {
        }
        catch (Exception exc) {
            log.info("Unhandled exception. " + exc.getMessage(), exc);
        }
        this.reply(String.format("550 %s: Permission denied", resName));
    }

    public void SendFileList(String[] params) throws IOException {
        ArrayList<FtpFileInfo> items;
        String path = "";
        if (params.length > 1) {
            path = params[1];
            if (path.startsWith("-la")) {
                path = path.substring(3);
            }
            while (path.startsWith(" ")) {
                path = path.substring(1);
            }
        }
        if ((items = this.getFileList(path)) == null) {
            this.reply(String.format("450 %s No such file or directory", path));
            return;
        }
        if (this.clientSession().getDataTransiver() == null) {
            this.reply("425 Unable to build data connection");
            return;
        }
        try {
            while (!this.clientSession().getDataTransiver().isConnected()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception exc) {
            log.info("Unhandled exception. " + exc.getMessage(), exc);
        }
        FtpSystemCoder systemCoder = FtpSystemCoderManager.getSystemCoder(this.clientSession().getFtpServer().getConfiguration());
        this.reply("125 Data connection already open; Transfer starting");
        boolean isNeedExtendedInfo = this.commandName.equals("LIST");
        try {
            String encoding = this.clientSession().getFtpServer().getConfiguration().getClientSideEncoding();
            for (int i = 0; i < items.size(); ++i) {
                FtpFileInfo curFileInfo = items.get(i);
                String curSerialized = "";
                curSerialized = isNeedExtendedInfo ? systemCoder.serializeFileInfo(curFileInfo) : curFileInfo.getName();
                byte[] data = curSerialized.getBytes(encoding);
                this.clientSession().getDataTransiver().getOutputStream().write(data);
                this.clientSession().getDataTransiver().getOutputStream().write("\r\n".getBytes());
            }
            this.clientSession().closeDataTransiver();
        }
        catch (Exception exc) {
            log.info("Unhandled exception. " + exc.getMessage());
            log.info("Data transmit failed.");
        }
        this.reply("226 Transfer complete");
    }
}

