/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.concurrent.locks;

import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.jboss.cache.util.concurrent.locks.AbstractSharedLockContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ReentrantSharedLockContainer<E>
extends AbstractSharedLockContainer<E> {
    ReentrantLock[] sharedLocks;

    public ReentrantSharedLockContainer(int concurrencyLevel) {
        this.initLocks(this.calculateNumberOfSegments(concurrencyLevel));
    }

    @Override
    protected void initLocks(int numLocks) {
        this.sharedLocks = new ReentrantLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new ReentrantLock();
        }
    }

    @Override
    public final ReentrantLock getLock(E object) {
        return this.sharedLocks[this.hashToIndex(object)];
    }

    @Override
    public final int getNumLocksHeld() {
        int i = 0;
        for (ReentrantLock l : this.sharedLocks) {
            if (!l.isLocked()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public final boolean ownsLock(E object, Object owner) {
        Lock lock = this.getLock((Object)object);
        return ((ReentrantLock)lock).isHeldByCurrentThread();
    }

    @Override
    public final boolean isLocked(E object) {
        Lock lock = this.getLock((Object)object);
        return ((ReentrantLock)lock).isLocked();
    }

    public String toString() {
        return "ReentrantSharedLockContainer{sharedLocks=" + (this.sharedLocks == null ? null : Arrays.asList(this.sharedLocks)) + '}';
    }

    @Override
    public void reset() {
        this.initLocks(this.sharedLocks.length);
    }

    @Override
    public int size() {
        return this.sharedLocks.length;
    }
}

