/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemAutocreator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.AbstractDefinitionComparator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.RelatedDefinition;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionComparator
extends AbstractDefinitionComparator<NodeDefinitionData> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.NodeDefinitionComparator");
    private final List<NodeData> affectedNodes;
    private final NodeTypeDataManager nodeTypeDataManager;
    private final ItemDataConsumer dataConsumer;
    private final ItemAutocreator itemAutocreator;

    public NodeDefinitionComparator(NodeTypeDataManager nodeTypeDataManager, ItemDataConsumer dataConsumer, ItemAutocreator itemAutocreator, List<NodeData> affectedNodes) {
        this.nodeTypeDataManager = nodeTypeDataManager;
        this.dataConsumer = dataConsumer;
        this.itemAutocreator = itemAutocreator;
        this.affectedNodes = affectedNodes;
    }

    public PlainChangesLog compare(NodeTypeData registeredNodeType, NodeDefinitionData[] ancestorDefinition, NodeDefinitionData[] recipientDefinition) throws ConstraintViolationException, RepositoryException {
        ArrayList sameDefinitionData = new ArrayList();
        ArrayList<RelatedDefinition<NodeDefinitionData>> changedDefinitionData = new ArrayList<RelatedDefinition<NodeDefinitionData>>();
        ArrayList<NodeDefinitionData> newDefinitionData = new ArrayList<NodeDefinitionData>();
        ArrayList<NodeDefinitionData> removedDefinitionData = new ArrayList<NodeDefinitionData>();
        this.init(ancestorDefinition, recipientDefinition, sameDefinitionData, changedDefinitionData, newDefinitionData, removedDefinitionData);
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        this.validateRemoved(registeredNodeType, removedDefinitionData, recipientDefinition, this.affectedNodes);
        this.validateAdded(registeredNodeType.getName(), newDefinitionData, this.affectedNodes, recipientDefinition);
        this.validateChanged(registeredNodeType.getName(), changedDefinitionData, this.affectedNodes, recipientDefinition);
        this.doAdd(newDefinitionData, changesLog, this.affectedNodes, registeredNodeType);
        return changesLog;
    }

    private void checkMandatoryItems(List<NodeData> nodesData, NodeDefinitionData nodeDefinitionData) throws RepositoryException, ConstraintViolationException {
        for (NodeData nodeData : nodesData) {
            ItemData child = this.dataConsumer.getItemData(nodeData, new QPathEntry(nodeDefinitionData.getName(), 0));
            if (child != null && child.isNode()) continue;
            throw new ConstraintViolationException("Fail to  add mandatory and not auto-created child node definition " + nodeDefinitionData.getName().getAsString() + " for " + nodeDefinitionData.getDeclaringNodeType().getAsString() + " because node " + nodeData.getQPath().getAsString() + " doesn't contains child node with name " + nodeDefinitionData.getName().getAsString());
        }
    }

    private void checkRequiredPrimaryType(InternalQName registeredNodeType, List<NodeData> nodesData, InternalQName[] ancestorRequiredPrimaryTypes, NodeDefinitionData recipientDefinitionData, NodeDefinitionData[] allRecipientDefinition) throws RepositoryException {
        InternalQName[] requiredPrimaryTypes = recipientDefinitionData.getRequiredPrimaryTypes();
        for (NodeData nodeData : nodesData) {
            int i;
            List<NodeData> childs;
            if (recipientDefinitionData.getName().equals((Object)Constants.JCR_ANY_NAME)) {
                childs = this.dataConsumer.getChildNodesData(nodeData);
                for (NodeData child : childs) {
                    if (!this.isResidualMatch(child.getQPath().getName(), allRecipientDefinition)) continue;
                    for (i = 0; i < requiredPrimaryTypes.length; ++i) {
                        if (this.nodeTypeDataManager.isNodeType(requiredPrimaryTypes[i], child.getPrimaryTypeName(), child.getMixinTypeNames())) continue;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("Fail to change ");
                        buffer.append(recipientDefinitionData.getName().getAsString());
                        buffer.append(" node definition for ");
                        buffer.append(registeredNodeType.getAsString());
                        buffer.append("node type from ");
                        if (ancestorRequiredPrimaryTypes != null) {
                            buffer.append(Arrays.toString((Object[])ancestorRequiredPrimaryTypes));
                        } else {
                            buffer.append(" '' ");
                        }
                        buffer.append(" to ");
                        buffer.append(Arrays.toString((Object[])recipientDefinitionData.getRequiredPrimaryTypes()));
                        buffer.append(" because ");
                        buffer.append(child.getQPath().getAsString());
                        buffer.append(" doesn't much ");
                        buffer.append(requiredPrimaryTypes[i].getAsString());
                        buffer.append(" as required primary type");
                        throw new ConstraintViolationException(buffer.toString());
                    }
                }
                continue;
            }
            childs = this.dataConsumer.getChildNodesData(nodeData);
            for (NodeData child : childs) {
                if (!child.getQPath().getName().equals((Object)recipientDefinitionData.getName())) continue;
                for (i = 0; i < requiredPrimaryTypes.length; ++i) {
                    if (this.nodeTypeDataManager.isNodeType(requiredPrimaryTypes[i], child.getPrimaryTypeName(), child.getMixinTypeNames())) continue;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Fail to change ");
                    buffer.append(recipientDefinitionData.getName().getAsString());
                    buffer.append(" node definition for ");
                    buffer.append(registeredNodeType.getAsString());
                    buffer.append("node type from ");
                    if (ancestorRequiredPrimaryTypes != null) {
                        buffer.append(Arrays.toString((Object[])ancestorRequiredPrimaryTypes));
                    } else {
                        buffer.append(" '' ");
                    }
                    buffer.append(" to ");
                    buffer.append(Arrays.toString((Object[])recipientDefinitionData.getRequiredPrimaryTypes()));
                    buffer.append(" because ");
                    buffer.append(child.getQPath().getAsString());
                    buffer.append("doesn't much ");
                    buffer.append(requiredPrimaryTypes[i].getAsString());
                    buffer.append(" as required primary type");
                    throw new ConstraintViolationException(buffer.toString());
                }
            }
        }
    }

    private void checkSameNameSibling(InternalQName registeredNodeType, List<NodeData> nodesData, InternalQName recipientName, NodeDefinitionData[] allRecipientDefinition) throws RepositoryException {
        for (NodeData nodeData : nodesData) {
            List<NodeData> childs2;
            List<NodeData> childs;
            if (recipientName.equals((Object)Constants.JCR_ANY_NAME)) {
                childs = this.dataConsumer.getChildNodesData(nodeData);
                for (NodeData child : childs) {
                    if (!this.isResidualMatch(child.getQPath().getName(), allRecipientDefinition)) continue;
                    childs2 = this.dataConsumer.getChildNodesData(child);
                    for (NodeData child2 : childs2) {
                        if (child2.getQPath().getIndex() <= 1) continue;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("Fail to change ");
                        buffer.append(recipientName.getAsString());
                        buffer.append(" node definition for ");
                        buffer.append(registeredNodeType.getAsString());
                        buffer.append("node type from AllowsSameNameSiblings = true to AllowsSameNameSiblings = false");
                        buffer.append(" because ");
                        buffer.append(child.getQPath().getAsString());
                        buffer.append(" contains more then one child with name");
                        buffer.append(child2.getQPath().getName().getAsString());
                        throw new ConstraintViolationException(buffer.toString());
                    }
                }
                continue;
            }
            childs = this.dataConsumer.getChildNodesData(nodeData);
            for (NodeData child : childs) {
                if (!child.getQPath().getName().equals((Object)recipientName)) continue;
                childs2 = this.dataConsumer.getChildNodesData(child);
                for (NodeData child2 : childs2) {
                    if (child2.getQPath().getIndex() <= 1) continue;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Fail to change ");
                    buffer.append(recipientName.getAsString());
                    buffer.append(" node definition for ");
                    buffer.append(registeredNodeType.getAsString());
                    buffer.append("node type from AllowsSameNameSiblings = true to AllowsSameNameSiblings = false");
                    buffer.append(" because ");
                    buffer.append(child.getQPath().getAsString());
                    buffer.append(" contains more then one child with name");
                    buffer.append(child2.getQPath().getName().getAsString());
                    throw new ConstraintViolationException(buffer.toString());
                }
            }
        }
    }

    private void doAdd(List<NodeDefinitionData> toAddList, PlainChangesLog changesLog, List<NodeData> nodesData, NodeTypeData registeredNodeType) throws RepositoryException {
        for (NodeData nodeData : nodesData) {
            for (NodeDefinitionData newNodeDefinitionData : toAddList) {
                if (newNodeDefinitionData.getName().equals((Object)Constants.JCR_ANY_NAME) || !newNodeDefinitionData.isAutoCreated()) continue;
                changesLog.addAll(this.itemAutocreator.makeAutoCreatedNodes(nodeData, registeredNodeType.getName(), new NodeDefinitionData[]{newNodeDefinitionData}, this.dataConsumer, nodeData.getACL().getOwner()).getAllStates());
            }
        }
    }

    private void validateAdded(InternalQName nodeTypeName, List<NodeDefinitionData> newDefinitionData, List<NodeData> nodesData, NodeDefinitionData[] recipientDefinition) throws RepositoryException {
        for (NodeDefinitionData nodeDefinitionData : newDefinitionData) {
            if (nodeDefinitionData.getName().equals((Object)Constants.JCR_ANY_NAME)) {
                this.checkRequiredPrimaryType(nodeTypeName, nodesData, null, nodeDefinitionData, recipientDefinition);
                this.checkSameNameSibling(nodeTypeName, nodesData, nodeDefinitionData.getName(), recipientDefinition);
                continue;
            }
            this.checkRequiredPrimaryType(nodeTypeName, nodesData, null, nodeDefinitionData, recipientDefinition);
            this.checkSameNameSibling(nodeTypeName, nodesData, nodeDefinitionData.getName(), recipientDefinition);
            if (!nodeDefinitionData.isMandatory() || nodeDefinitionData.isAutoCreated()) continue;
            this.checkMandatoryItems(nodesData, nodeDefinitionData);
        }
    }

    private void validateChanged(InternalQName registeredNodeType, List<RelatedDefinition<NodeDefinitionData>> changedDefinitionData, List<NodeData> nodesData, NodeDefinitionData[] allRecipientDefinition) throws RepositoryException {
        for (RelatedDefinition<NodeDefinitionData> changedDefinitions : changedDefinitionData) {
            ItemData child;
            NodeDefinitionData ancestorDefinitionData = changedDefinitions.getAncestorDefinition();
            NodeDefinitionData recipientDefinitionData = changedDefinitions.getRecepientDefinition();
            if (!ancestorDefinitionData.isMandatory() && recipientDefinitionData.isMandatory()) {
                for (NodeData nodeData : nodesData) {
                    child = this.dataConsumer.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0));
                    if (child != null && child.isNode()) continue;
                    String message = "Can not change " + recipientDefinitionData.getName().getAsString() + " node definition for " + registeredNodeType.getAsString() + " node type " + " from mandatory=false to mandatory = true , because " + " node " + nodeData.getQPath().getAsString() + " doesn't have child node with name " + recipientDefinitionData.getName().getAsString();
                    throw new ConstraintViolationException(message);
                }
            }
            if (!ancestorDefinitionData.isProtected() && recipientDefinitionData.isProtected()) {
                for (NodeData nodeData : nodesData) {
                    child = this.dataConsumer.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0));
                    if (child != null && child.isNode()) continue;
                    String message = "Fail to  change " + recipientDefinitionData.getName().getAsString() + " node definition for " + registeredNodeType.getAsString() + " node type  from protected=false to Protected = true , because " + " node " + nodeData.getQPath().getAsString() + " doesn't have child node with name " + recipientDefinitionData.getName().getAsString();
                    throw new ConstraintViolationException(message);
                }
            }
            if (!Arrays.deepEquals((Object[])ancestorDefinitionData.getRequiredPrimaryTypes(), (Object[])recipientDefinitionData.getRequiredPrimaryTypes())) {
                this.checkRequiredPrimaryType(registeredNodeType, nodesData, ancestorDefinitionData.getRequiredPrimaryTypes(), recipientDefinitionData, allRecipientDefinition);
            }
            if (!ancestorDefinitionData.isAllowsSameNameSiblings() || recipientDefinitionData.isAllowsSameNameSiblings()) continue;
            this.checkSameNameSibling(registeredNodeType, nodesData, recipientDefinitionData.getName(), allRecipientDefinition);
        }
    }

    private void validateRemoved(NodeTypeData registeredNodeType, List<NodeDefinitionData> removedDefinitionData, NodeDefinitionData[] recipientDefinition, List<NodeData> nodesData) throws ConstraintViolationException, RepositoryException {
        for (NodeDefinitionData removeNodeDefinitionData : removedDefinitionData) {
            if (removeNodeDefinitionData.getName().equals((Object)Constants.JCR_ANY_NAME)) {
                for (NodeData nodeData : nodesData) {
                    List<NodeData> childs = this.dataConsumer.getChildNodesData(nodeData);
                    if (childs.size() <= 0) continue;
                    for (NodeData nodeData2 : childs) {
                        if (this.isNonResidualMatch(nodeData2.getQPath().getName(), recipientDefinition)) continue;
                        String msg = "Can't remove node definition " + removeNodeDefinitionData.getName().getAsString() + "  for " + registeredNodeType.getName().getAsString() + " node type because node " + nodeData.getQPath().getAsString() + " " + " countains child nodes with name " + nodeData2.getQPath().getName().getAsString();
                        throw new ConstraintViolationException(msg);
                    }
                }
                continue;
            }
            if (this.isResidualMatch(removeNodeDefinitionData.getName(), recipientDefinition)) continue;
            for (NodeData nodeData : nodesData) {
                ItemData child = this.dataConsumer.getItemData(nodeData, new QPathEntry(removeNodeDefinitionData.getName(), 0));
                if (child == null || !child.isNode()) continue;
                throw new ConstraintViolationException("Can't remove node definition " + removeNodeDefinitionData.getName().getAsString() + "  for " + registeredNodeType.getName().getAsString() + " node type because node " + nodeData.getQPath().getAsString() + " " + " countains child node with name " + child.getQPath().getName().getAsString());
            }
        }
    }
}

