/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.runtime.impl.XMLWriterBase;

public abstract class StreamWriterBase
extends XMLWriterBase {
    protected final byte[] m_quotEntityBytes;
    protected final byte[] m_ampEntityBytes;
    protected final byte[] m_gtEntityBytes;
    protected final byte[] m_ltEntityBytes;
    protected final byte[] m_cdataStartBytes;
    protected final byte[] m_cdataEndBytes;
    private IOutByteBuffer m_byteBuffer;
    private final String m_encodingName;
    private final StreamWriterBase m_baseWriter;
    protected byte[] m_buffer;
    protected int m_fillOffset;
    protected byte[][] m_prefixBytes;
    protected byte[][][] m_extensionBytes;
    private boolean m_indent;
    private int m_indentBase;
    private int m_indentPerLevel;
    private byte[] m_indentSequence;

    protected StreamWriterBase(String enc, String[] uris) {
        super(uris);
        this.m_encodingName = enc;
        this.m_baseWriter = null;
        this.m_prefixBytes = new byte[uris.length][];
        try {
            this.m_quotEntityBytes = "&quot;".getBytes(this.m_encodingName);
            this.m_ampEntityBytes = "&amp;".getBytes(this.m_encodingName);
            this.m_gtEntityBytes = "&gt;".getBytes(this.m_encodingName);
            this.m_ltEntityBytes = "&lt;".getBytes(this.m_encodingName);
            this.m_cdataStartBytes = "<![CDATA[".getBytes(this.m_encodingName);
            this.m_cdataEndBytes = "]]>".getBytes(this.m_encodingName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Internal error - unsupported encoding " + this.m_encodingName);
        }
    }

    public StreamWriterBase(StreamWriterBase base, String[] uris) {
        super(base, uris);
        this.m_encodingName = base.m_encodingName;
        this.m_baseWriter = base;
        this.m_prefixBytes = new byte[uris.length][];
        this.m_byteBuffer = base.m_byteBuffer;
        this.m_buffer = base.m_buffer;
        this.m_fillOffset = base.m_fillOffset;
        this.m_indent = base.m_indent;
        this.m_indentBase = base.m_indentBase;
        this.m_indentPerLevel = base.m_indentPerLevel;
        this.m_indentSequence = base.m_indentSequence;
        byte[][][] extbytes = base.m_extensionBytes;
        if (extbytes != null) {
            this.m_extensionBytes = new byte[extbytes.length][][];
            System.arraycopy(extbytes, 0, this.m_extensionBytes, 0, this.m_extensionBytes.length);
        }
        this.m_quotEntityBytes = base.m_quotEntityBytes;
        this.m_ampEntityBytes = base.m_ampEntityBytes;
        this.m_gtEntityBytes = base.m_gtEntityBytes;
        this.m_ltEntityBytes = base.m_ltEntityBytes;
        this.m_cdataStartBytes = base.m_cdataStartBytes;
        this.m_cdataEndBytes = base.m_cdataEndBytes;
    }

    public void setBuffer(IOutByteBuffer buff) {
        this.m_byteBuffer = buff;
        this.m_buffer = buff.getBuffer();
        this.m_fillOffset = buff.getOffset();
    }

    public String getEncodingName() {
        return this.m_encodingName;
    }

    public void setNamespaceUris(String[] uris) throws IOException {
        this.reset();
        boolean diff = false;
        String[] olds = this.getNamespaces();
        if (olds.length == uris.length) {
            for (int i = 0; i < uris.length; ++i) {
                if (uris[i].equals(olds[i])) continue;
                diff = true;
                break;
            }
        } else {
            diff = true;
        }
        if (diff) {
            this.internalSetUris(uris);
            this.m_prefixBytes = new byte[uris.length][];
            this.defineNamespace(0, "");
            this.defineNamespace(1, "xml");
        }
    }

    public void setIndentSpaces(int count, String newline, char indent) {
        if (count >= 0) {
            try {
                if (newline == null) {
                    newline = "\n";
                }
                this.m_indent = true;
                byte[] base = newline.getBytes(this.m_encodingName);
                this.m_indentBase = base.length;
                byte[] per = new String(new char[]{indent}).getBytes(this.m_encodingName);
                this.m_indentPerLevel = count * per.length;
                int length = this.m_indentBase + this.m_indentPerLevel * 10;
                this.m_indentSequence = new byte[length];
                for (int i = 0; i < length; ++i) {
                    if (i < newline.length()) {
                        this.m_indentSequence[i] = base[i];
                        continue;
                    }
                    int index = (i - this.m_indentBase) % per.length;
                    this.m_indentSequence[i] = per[index];
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding " + this.m_encodingName + " not recognized by JVM");
            }
        } else {
            this.m_indent = false;
        }
    }

    protected void makeSpace(int length) throws IOException {
        if (this.m_fillOffset + length > this.m_buffer.length) {
            this.m_byteBuffer.setOffset(this.m_fillOffset);
            this.m_byteBuffer.free(this.m_fillOffset, length);
            this.m_buffer = this.m_byteBuffer.getBuffer();
            this.m_fillOffset = this.m_byteBuffer.getOffset();
        }
    }

    protected void undefineNamespace(int index) {
        if (index < this.m_prefixBytes.length) {
            this.m_prefixBytes[index] = null;
        } else if (this.m_extensionBytes != null) {
            index -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionBytes.length; ++i) {
                int length = this.m_extensionBytes[i].length;
                if (index < length) {
                    this.m_extensionBytes[i][index] = null;
                    break;
                }
                index -= length;
            }
        } else {
            throw new IllegalArgumentException("Index out of range");
        }
    }

    protected void writePrefix(int index) throws IOException {
        try {
            byte[] bytes = null;
            index = this.translateNamespace(index);
            if (index < this.m_prefixBytes.length) {
                bytes = this.m_prefixBytes[index];
            } else if (this.m_extensionBytes != null) {
                index -= this.m_prefixes.length;
                for (int i = 0; i < this.m_extensionBytes.length; ++i) {
                    int length = this.m_extensionBytes[i].length;
                    if (index < length) {
                        bytes = this.m_extensionBytes[i][index];
                        break;
                    }
                    index -= length;
                }
            }
            if (bytes.length > 0) {
                this.makeSpace(bytes.length);
                System.arraycopy(bytes, 0, this.m_buffer, this.m_fillOffset, bytes.length);
                this.m_fillOffset += bytes.length;
            }
        }
        catch (NullPointerException ex) {
            throw new IOException("Namespace URI has not been declared.");
        }
    }

    protected int writeEntity(byte[] bytes, int offset) {
        System.arraycopy(bytes, 0, this.m_buffer, offset, bytes.length);
        return offset + bytes.length;
    }

    public void pushExtensionNamespaces(String[] uris) {
        super.pushExtensionNamespaces(uris);
        byte[][] items = new byte[uris.length][];
        if (this.m_extensionBytes == null) {
            this.m_extensionBytes = new byte[][][]{items};
        } else {
            int length = this.m_extensionBytes.length;
            byte[][][] grow = new byte[length + 1][][];
            System.arraycopy(this.m_extensionBytes, 0, grow, 0, length);
            grow[length] = items;
            this.m_extensionBytes = grow;
        }
    }

    public void popExtensionNamespaces() {
        super.popExtensionNamespaces();
        int length = this.m_extensionBytes.length;
        if (length == 1) {
            this.m_extensionBytes = null;
        } else {
            byte[][][] shrink = new byte[length - 1][][];
            System.arraycopy(this.m_extensionBytes, 0, shrink, 0, length - 1);
            this.m_extensionBytes = shrink;
        }
    }

    public void indent(int bias) throws IOException {
        if (this.m_indent) {
            this.flagContent();
            int length = this.m_indentBase + (this.getNestingDepth() + bias) * this.m_indentPerLevel;
            if (length > this.m_indentSequence.length) {
                int use = Math.max(length, this.m_indentSequence.length * 2 - this.m_indentBase);
                byte[] grow = new byte[use];
                System.arraycopy(this.m_indentSequence, 0, grow, 0, this.m_indentSequence.length);
                for (int i = this.m_indentSequence.length; i < use; ++i) {
                    grow[i] = grow[this.m_indentBase];
                }
                this.m_indentSequence = grow;
            }
            this.makeSpace(length);
            System.arraycopy(this.m_indentSequence, 0, this.m_buffer, this.m_fillOffset, length);
            this.m_fillOffset += length;
        }
    }

    public void indent() throws IOException {
        this.indent(0);
    }

    public void flush() throws IOException {
        this.flagContent();
        this.m_byteBuffer.setOffset(this.m_fillOffset);
        this.m_byteBuffer.flush();
        this.m_fillOffset = this.m_byteBuffer.getOffset();
        if (this.m_baseWriter != null) {
            this.m_baseWriter.m_fillOffset = this.m_fillOffset;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.m_byteBuffer.finish();
    }
}

