/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.access.AuthenticationPolicy;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.xml.ExportImportFactory;
import org.exoplatform.services.jcr.impl.xml.importing.StreamImporter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.picocontainer.ComponentAdapter;

public class RepositoryImpl
implements ManageableRepository {
    private static HashMap<String, String> descriptors = new HashMap();
    private static final CredentialsImpl SYSTEM_CREDENTIALS = new CredentialsImpl(SystemIdentity.SYSTEM, "".toCharArray());
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryImpl");
    private final RepositoryContainer repositoryContainer;
    private final String systemWorkspaceName;
    private final String name;
    private final RepositoryEntry config;
    private final AuthenticationPolicy authenticationPolicy;
    private int state = 0;

    public RepositoryImpl(RepositoryContainer container) throws RepositoryException, RepositoryConfigurationException {
        this.config = (RepositoryEntry)container.getComponentInstanceOfType(RepositoryEntry.class);
        this.authenticationPolicy = (AuthenticationPolicy)container.getComponentInstanceOfType(AuthenticationPolicy.class);
        this.name = this.config.getName();
        this.systemWorkspaceName = this.config.getSystemWorkspaceName();
        this.repositoryContainer = container;
    }

    public void addItemPersistenceListener(String workspaceName, ItemsPersistenceListener listener) {
        PersistentDataManager pmanager = (PersistentDataManager)this.repositoryContainer.getWorkspaceContainer(workspaceName).getComponentInstanceOfType(PersistentDataManager.class);
        pmanager.addItemPersistenceListener(listener);
    }

    public boolean canRemoveWorkspace(String workspaceName) throws NoSuchWorkspaceException {
        if (this.repositoryContainer.getWorkspaceEntry(workspaceName) == null) {
            throw new NoSuchWorkspaceException("No such workspace " + workspaceName);
        }
        if (workspaceName.equals(this.config.getSystemWorkspaceName())) {
            return false;
        }
        SessionRegistry sessionRegistry = (SessionRegistry)this.repositoryContainer.getComponentInstance(SessionRegistry.class);
        return sessionRegistry != null && !sessionRegistry.isInUse(workspaceName);
    }

    public void configWorkspace(WorkspaceEntry wsConfig) throws RepositoryConfigurationException, RepositoryException {
        if (this.isWorkspaceInitialized(wsConfig.getName())) {
            throw new RepositoryConfigurationException("Workspace '" + wsConfig.getName() + "' is presumably initialized. config canceled");
        }
        try {
            this.repositoryContainer.registerWorkspace(wsConfig);
        }
        catch (RepositoryConfigurationException e) {
            WorkspaceContainer workspaceContainer = this.repositoryContainer.getWorkspaceContainer(wsConfig.getName());
            this.repositoryContainer.unregisterComponentByInstance((Object)workspaceContainer);
            this.repositoryContainer.unregisterComponent(wsConfig.getName());
            throw new RepositoryConfigurationException(e);
        }
        catch (RepositoryException e) {
            WorkspaceContainer workspaceContainer = this.repositoryContainer.getWorkspaceContainer(wsConfig.getName());
            this.repositoryContainer.unregisterComponentByInstance((Object)workspaceContainer);
            this.repositoryContainer.unregisterComponent(wsConfig.getName());
            throw new RepositoryException((Throwable)e);
        }
    }

    public synchronized void createWorkspace(String workspaceName) throws RepositoryException {
        if (this.isWorkspaceInitialized(workspaceName)) {
            LOG.warn((Object)("Workspace '" + workspaceName + "' is presumably initialized. config canceled"));
            return;
        }
        WorkspaceContainer wsContainer = this.repositoryContainer.getWorkspaceContainer(workspaceName);
        if (wsContainer == null) {
            throw new RepositoryException("Workspace " + workspaceName + " is not configured. Use RepositoryImpl.configWorkspace() method");
        }
        this.repositoryContainer.getWorkspaceContainer(workspaceName).getWorkspaceInitializer().initWorkspace();
        wsContainer.start();
        LOG.info((Object)("Workspace " + workspaceName + "@" + this.name + " is initialized"));
    }

    public RepositoryEntry getConfiguration() {
        return this.config;
    }

    public String getDescriptor(String key) {
        return descriptors.get(key);
    }

    public String[] getDescriptorKeys() {
        String[] keys = new String[descriptors.size()];
        Iterator<String> decriptorsList = descriptors.keySet().iterator();
        int i = 0;
        while (decriptorsList.hasNext()) {
            keys[i++] = decriptorsList.next();
        }
        return keys;
    }

    public LocationFactory getLocationFactory() {
        return this.repositoryContainer.getLocationFactory();
    }

    public String getName() {
        return this.name;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.repositoryContainer.getNamespaceRegistry();
    }

    public ExtendedNodeTypeManager getNodeTypeManager() {
        return this.repositoryContainer.getNodeTypeManager();
    }

    public SessionImpl getSystemSession() throws RepositoryException {
        return this.getSystemSession(this.systemWorkspaceName);
    }

    public SessionImpl getSystemSession(String workspaceName) throws RepositoryException {
        WorkspaceContainer workspaceContainer;
        if (this.getState() == 0) {
            LOG.warn((Object)("Repository " + this.getName() + " is OFFLINE."));
        }
        if ((workspaceContainer = this.repositoryContainer.getWorkspaceContainer(workspaceName)) == null || !workspaceContainer.getWorkspaceInitializer().isWorkspaceInitialized()) {
            throw new RepositoryException("Workspace " + workspaceName + " not found or workspace is not initialized");
        }
        SessionFactory sessionFactory = workspaceContainer.getSessionFactory();
        return sessionFactory.createSession(this.authenticationPolicy.authenticate(SYSTEM_CREDENTIALS));
    }

    public String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    public String[] getWorkspaceNames() {
        List adapters = this.repositoryContainer.getComponentAdaptersOfType(WorkspaceContainer.class);
        ArrayList<String> workspaceNames = new ArrayList<String>();
        for (int i = 0; i < adapters.size(); ++i) {
            ComponentAdapter adapter = (ComponentAdapter)adapters.get(i);
            String workspaceName = new String((String)adapter.getComponentKey());
            try {
                if (!this.repositoryContainer.getWorkspaceContainer(workspaceName).getWorkspaceInitializer().isWorkspaceInitialized()) continue;
                workspaceNames.add(workspaceName);
                continue;
            }
            catch (RuntimeException e) {
                LOG.warn((Object)e.getLocalizedMessage());
            }
        }
        return workspaceNames.toArray(new String[workspaceNames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importWorkspace(String wsName, InputStream xmlStream) throws RepositoryException, IOException {
        this.createWorkspace(wsName);
        SessionImpl sysSession = this.getSystemSession(wsName);
        try {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("respectPropertyDefinitionsConstraints", true);
            NodeData rootData = (NodeData)((NodeImpl)sysSession.getRootNode()).getData();
            TransactionableDataManager dataManager = sysSession.getTransientNodesManager().getTransactManager();
            ExportImportFactory eiFactory = new ExportImportFactory();
            StreamImporter importer = eiFactory.getWorkspaceImporter(rootData, 3, dataManager, dataManager, sysSession.getWorkspace().getNodeTypesHolder(), sysSession.getLocationFactory(), sysSession.getValueFactory(), this.getNamespaceRegistry(), sysSession.getAccessManager(), sysSession.getUserState(), context, this, wsName);
            importer.importStream(xmlStream);
            Object var10_9 = null;
            sysSession.logout();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            sysSession.logout();
            throw throwable;
        }
    }

    public void internalRemoveWorkspace(String workspaceName) throws RepositoryException {
        WorkspaceContainer workspaceContainer = null;
        if (this.isWorkspaceInitialized(workspaceName)) {
            workspaceContainer = this.repositoryContainer.getWorkspaceContainer(workspaceName);
            try {
                workspaceContainer.stop();
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
            this.repositoryContainer.unregisterComponentByInstance((Object)workspaceContainer);
            this.repositoryContainer.unregisterComponent(workspaceName);
        }
    }

    public boolean isWorkspaceInitialized(String workspaceName) {
        try {
            return this.repositoryContainer.getWorkspaceContainer(workspaceName).getWorkspaceInitializer().isWorkspaceInitialized();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Session login() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, null);
    }

    public Session login(Credentials credentials) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspaceName);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (this.getState() == 0) {
            LOG.warn((Object)("Repository " + this.getName() + " is OFFLINE."));
        }
        ConversationState state = credentials != null ? this.authenticationPolicy.authenticate(credentials) : this.authenticationPolicy.authenticate();
        return this.internalLogin(state, workspaceName);
    }

    SessionImpl internalLogin(ConversationState state, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (workspaceName == null && (workspaceName = this.config.getDefaultWorkspaceName()) == null) {
            throw new NoSuchWorkspaceException("Both workspace and default-workspace name are null! ");
        }
        if (!this.isWorkspaceInitialized(workspaceName)) {
            throw new NoSuchWorkspaceException("Workspace '" + workspaceName + "' not found. " + "Probably is not initialized. If so either Initialize it manually or turn on the RepositoryInitializer");
        }
        SessionFactory sessionFactory = this.repositoryContainer.getWorkspaceContainer(workspaceName).getSessionFactory();
        return sessionFactory.createSession(state);
    }

    public void removeWorkspace(String workspaceName) throws RepositoryException {
        if (!this.canRemoveWorkspace(workspaceName)) {
            throw new RepositoryException("Workspace " + workspaceName + " in use. If you want to " + " remove workspace close all open sessions");
        }
        this.internalRemoveWorkspace(workspaceName);
        this.config.getWorkspaceEntries().remove(this.repositoryContainer.getWorkspaceEntry(workspaceName));
    }

    public WorkspaceContainerFacade getWorkspaceContainer(String workspaceName) {
        return new WorkspaceContainerFacade(workspaceName, this.repositoryContainer.getWorkspaceContainer(workspaceName));
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        switch (state) {
            case 1: {
                this.setAllWorkspacesReadOnly(false);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                this.setAllWorkspacesReadOnly(true);
            }
        }
        this.state = state;
    }

    private void setAllWorkspacesReadOnly(boolean wsStatus) {
        for (String workspaceName : this.getWorkspaceNames()) {
            WorkspaceContainerFacade wsFacade = this.getWorkspaceContainer(workspaceName);
            PersistentDataManager dataManager = (PersistentDataManager)wsFacade.getComponent(PersistentDataManager.class);
            dataManager.setReadOnly(wsStatus);
        }
    }

    static {
        descriptors.put("jcr.specification.version", "1.0");
        descriptors.put("jcr.specification.name", "Content Repository Java Technology API");
        descriptors.put("jcr.repository.vendor", "eXo Platform SAS");
        descriptors.put("jcr.repository.vendor.url", "http://www.exoplatform.com");
        descriptors.put("jcr.repository.name", "eXo Java Content Repository");
        descriptors.put("jcr.repository.version", "1.7.1");
        descriptors.put("level.1.supported", "true");
        descriptors.put("level.2.supported", "true");
        descriptors.put("option.transactions.supported", "true");
        descriptors.put("option.versioning.supported", "true");
        descriptors.put("option.observation.supported", "true");
        descriptors.put("option.locking.supported", "true");
        descriptors.put("option.query.sql.supported", "true");
        descriptors.put("query.xpath.pos.index", "true");
        descriptors.put("query.xpath.doc.order", "true");
    }
}

