/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.htmlparser.Parser;
import org.htmlparser.beans.StringBean;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class HTMLDocumentReader
extends BaseDocumentReader {
    public HTMLDocumentReader(InitParams params) {
    }

    public HTMLDocumentReader() {
    }

    public String[] getMimeTypes() {
        return new String[]{"text/html", "application/x-groovy+html"};
    }

    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        String refined_text = new String();
        try {
            int len;
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((len = is.read(buffer)) > 0) {
                bos.write(buffer, 0, len);
            }
            bos.close();
            String html = new String(bos.toByteArray());
            Parser parser = Parser.createParser((String)html, null);
            StringBean sb = new StringBean();
            parser.visitAllNodesWith((NodeVisitor)sb);
            String text = sb.getStrings();
            refined_text = text != null ? text : "";
        }
        catch (ParserException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return refined_text;
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Properties();
    }
}

