/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.pc.portlet.state.StateConversionException;
import org.gatein.pc.portlet.state.StateConverter;
import org.gatein.pc.portlet.state.producer.PortletState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateConverterV0
implements StateConverter {
    private static final int MAGIC_VALUE = -1101552363;
    private static final byte VERSION_ID = 0;

    @Override
    public <S extends Serializable> S marshall(PortletStateType<S> stateType, PortletState state) throws StateConversionException, IllegalArgumentException {
        if (stateType.getJavaType().equals(byte[].class)) {
            byte[] bytes = this.marshall(state);
            return (S)((Serializable)bytes);
        }
        throw new UnsupportedOperationException();
    }

    public byte[] marshall(PortletState state) throws StateConversionException {
        if (state == null) {
            throw new IllegalArgumentException("No null state");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(-1101552363);
            dos.write(0);
            dos.writeUTF(state.getPortletId());
            PropertyMap map = state.getProperties();
            dos.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                String[] strings = value.toArray(new String[value.size()]);
                dos.writeUTF(key);
                dos.writeInt(strings.length);
                for (String string : strings) {
                    if (string == null) {
                        dos.writeBoolean(true);
                        continue;
                    }
                    dos.writeBoolean(false);
                    dos.writeUTF(string);
                }
            }
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new StateConversionException(e);
        }
    }

    @Override
    public <S extends Serializable> PortletState unmarshall(PortletStateType<S> stateType, S marshalledState) throws StateConversionException, IllegalArgumentException {
        if (stateType.getJavaType().equals(byte[].class)) {
            byte[] bytes = (byte[])marshalledState;
            return this.unmarshall(bytes);
        }
        throw new UnsupportedOperationException();
    }

    public PortletState unmarshall(byte[] marshalledState) throws StateConversionException {
        if (marshalledState == null) {
            throw new IllegalArgumentException("No null bytes");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(marshalledState);
            DataInputStream dis = new DataInputStream(bais);
            int magicValue = dis.readInt();
            if (magicValue != -1101552363) {
                throw new StateConversionException("Bad magic value " + Integer.toHexString(magicValue));
            }
            byte versionId = dis.readByte();
            if (versionId > 0) {
                throw new StateConversionException("Bad version id " + versionId);
            }
            String portletId = dis.readUTF();
            int size = dis.readInt();
            SimplePropertyMap properties = new SimplePropertyMap(size);
            while (size-- > 0) {
                String key = dis.readUTF();
                int length = dis.readInt();
                String[] strings = new String[length];
                for (int i = 0; i < strings.length; ++i) {
                    String string;
                    boolean isNull = dis.readBoolean();
                    if (isNull) continue;
                    strings[i] = string = dis.readUTF();
                }
                List<Object> value = Arrays.asList((Object[])strings.clone());
                properties.setProperty(key, value);
            }
            return new PortletState(portletId, properties);
        }
        catch (IOException e) {
            throw new StateConversionException(e);
        }
    }
}

