/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.annotation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDescriptorFactory {
    public List<ComponentDescriptor> createComponentDescriptors(Class<?> componentClass, Class<?> componentRoleClass) {
        ArrayList<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>();
        Component component = componentClass.getAnnotation(Component.class);
        String[] hints = component != null && component.hints().length > 0 ? component.hints() : (component != null && component.value().trim().length() > 0 ? new String[]{component.value().trim()} : new String[]{"default"});
        for (String hint : hints) {
            descriptors.add(this.createComponentDescriptor(componentClass, hint, componentRoleClass));
        }
        return descriptors;
    }

    private ComponentDescriptor createComponentDescriptor(Class<?> componentClass, String hint, Class<?> componentRoleClass) {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setRole(componentRoleClass);
        descriptor.setImplementation(componentClass);
        descriptor.setRoleHint(hint);
        InstantiationStrategy instantiationStrategy = componentClass.getAnnotation(InstantiationStrategy.class);
        if (instantiationStrategy != null) {
            descriptor.setInstantiationStrategy(instantiationStrategy.value());
        } else {
            descriptor.setInstantiationStrategy(ComponentInstantiationStrategy.SINGLETON);
        }
        for (Field field : ReflectionUtils.getAllFields(componentClass)) {
            ComponentDependency dependency = this.createComponentDependency(field);
            if (dependency == null) continue;
            descriptor.addComponentDependency(dependency);
        }
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ComponentDependency createComponentDependency(Field field) {
        DefaultComponentDependency dependency = null;
        Requirement requirement = field.getAnnotation(Requirement.class);
        if (requirement == null) return dependency;
        dependency = new DefaultComponentDependency();
        dependency.setMappingType(field.getType());
        dependency.setName(field.getName());
        if (this.isRequirementListType(field.getType())) {
            if (requirement.role().getName().equals(Object.class.getName())) return null;
            dependency.setRole(requirement.role());
        } else {
            dependency.setRole(field.getType());
        }
        if (requirement.value().trim().length() > 0) {
            dependency.setRoleHint(requirement.value());
        }
        if (requirement.hints().length <= 0) return dependency;
        dependency.setHints(requirement.hints());
        return dependency;
    }

    private boolean isRequirementListType(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }
}

