/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.wikimodel;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.internal.parser.WikiModelXHTMLParser;
import org.xwiki.rendering.internal.parser.WikiModelXWiki20Parser;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.WrappingListener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.util.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiModelParserUtils
extends ParserUtils {
    public List<Block> parseInline(Parser parser, String content) throws ParseException {
        List result;
        if (WikiModelXWiki20Parser.class.isAssignableFrom(parser.getClass())) {
            result = parser.parse((Reader)new StringReader("xwikimarker " + content)).getChildren();
        } else if (WikiModelXHTMLParser.class.isAssignableFrom(parser.getClass())) {
            String contentToParse = "<p>xwikimarker ";
            contentToParse = content.startsWith("<p>") ? contentToParse + content.substring(3) : contentToParse + content + "</p>";
            result = parser.parse((Reader)new StringReader(contentToParse)).getChildren();
        } else {
            result = parser.parse((Reader)new StringReader(content)).getChildren();
        }
        this.removeTopLevelParagraph(result);
        if (WikiModelXWiki20Parser.class.isAssignableFrom(parser.getClass()) || WikiModelXHTMLParser.class.isAssignableFrom(parser.getClass())) {
            result.remove(0);
            result.remove(0);
        }
        return result;
    }

    public void parseInline(StreamParser parser, String content, Listener listener) throws ParseException {
        WrappingListener inlineFilterListener = new WrappingListener(){
            private boolean foundWord = false;
            private boolean foundSpace = false;

            public void beginSection(Map<String, String> parameters) {
            }

            public void endSection(Map<String, String> parameters) {
            }

            public void beginParagraph(Map<String, String> parameters) {
            }

            public void endParagraph(Map<String, String> parameters) {
            }

            public void onWord(String word) {
                if (this.foundWord) {
                    super.onWord(word);
                } else {
                    this.foundWord = true;
                }
            }

            public void onSpace() {
                if (this.foundSpace) {
                    super.onSpace();
                } else {
                    this.foundSpace = true;
                }
            }
        };
        inlineFilterListener.setWrappedListener(listener);
        parser.parse((Reader)new StringReader("wikimarker " + content), (Listener)inlineFilterListener);
    }
}

