/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer;

import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.listener.LinkType;
import org.xwiki.rendering.renderer.LinkReferenceSerializer;

@Component
public class DefaultLinkReferenceSerializer
implements LinkReferenceSerializer {
    private static final String[] ESCAPE_REPLACEMENTS_REFERENCE = new String[]{"\\?", "\\@", "\\#"};
    private static final String[] ESCAPES_REFERENCE = new String[]{"?", "@", "#"};
    private static final String[] ESCAPE_REPLACEMENTS_EXTRA = new String[]{"\\?", "\\@", "\\#", "\\\\"};
    private static final String[] ESCAPES_EXTRA = new String[]{"?", "@", "#", "\\"};

    public String serialize(Link link) {
        StringBuilder buffer = new StringBuilder();
        if (link.getReference() != null) {
            String normalizedReference = link.getReference();
            if (link.getType() != LinkType.URI) {
                normalizedReference = this.addEscapesToReferencePart(link.getReference());
            }
            buffer.append(normalizedReference);
        }
        if (link.getType() != LinkType.URI) {
            if (link.getAnchor() != null) {
                buffer.append('#');
                buffer.append(this.addEscapesToExtraParts(link.getAnchor()));
            }
            if (link.getQueryString() != null) {
                buffer.append('?');
                buffer.append(this.addEscapesToExtraParts(link.getQueryString()));
            }
            if (link.getInterWikiAlias() != null) {
                buffer.append('@');
                buffer.append(this.addEscapesToExtraParts(link.getInterWikiAlias()));
            }
        }
        return buffer.toString();
    }

    private String addEscapesToReferencePart(String text) {
        return StringUtils.replaceEach((String)text, (String[])ESCAPES_REFERENCE, (String[])ESCAPE_REPLACEMENTS_REFERENCE);
    }

    private String addEscapesToExtraParts(String text) {
        return StringUtils.replaceEach((String)text, (String[])ESCAPES_EXTRA, (String[])ESCAPE_REPLACEMENTS_EXTRA);
    }
}

