/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.listener.Attachment;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.listener.LinkType;
import org.xwiki.rendering.parser.AttachmentParser;
import org.xwiki.rendering.renderer.LinkLabelGenerator;
import org.xwiki.rendering.renderer.URILabelGenerator;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.xhtml.XHTMLLinkRenderer;
import org.xwiki.rendering.wiki.WikiModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultXHTMLLinkRenderer
implements XHTMLLinkRenderer,
Initializable {
    private static final String CLASS = "class";
    private static final String SPAN = "span";
    private static final String ATTACH = "attach:";
    private static final String WIKILINK = "wikilink";
    private XHTMLWikiPrinter xhtmlPrinter;
    private boolean hasLabel;
    private WikiModel wikiModel;
    @Requirement
    private LinkLabelGenerator linkLabelGenerator;
    @Requirement
    private AttachmentParser attachmentParser;
    @Requirement
    private ComponentManager componentManager;

    public void initialize() throws InitializationException {
        try {
            this.wikiModel = (WikiModel)this.componentManager.lookup(WikiModel.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
    }

    @Override
    public void setHasLabel(boolean hasLabel) {
        this.hasLabel = hasLabel;
    }

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.xhtmlPrinter = printer;
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.xhtmlPrinter;
    }

    @Override
    public void beginLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        if (this.wikiModel == null || link.isExternalLink()) {
            this.beginExternalLink(link, isFreeStandingURI, parameters);
        } else {
            this.beginInternalLink(link, isFreeStandingURI, parameters);
        }
    }

    private void beginExternalLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        LinkedHashMap<String, String> spanAttributes = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> aAttributes = new LinkedHashMap<String, String>();
        aAttributes.putAll(parameters);
        spanAttributes.put(CLASS, "wikiexternallink");
        if (isFreeStandingURI) {
            aAttributes.put(CLASS, "wikimodel-freestanding");
        }
        if (link.getType() != LinkType.INTERWIKI) {
            if (StringUtils.isEmpty((String)link.getReference())) {
                this.renderAutoLink(link, spanAttributes, aAttributes);
            } else if (this.wikiModel != null && link.getType() == LinkType.URI && link.getReference().startsWith(ATTACH)) {
                Attachment attachment = this.attachmentParser.parse(link.getReference().substring(ATTACH.length()));
                aAttributes.put("href", this.wikiModel.getAttachmentURL(attachment.getDocumentName(), attachment.getAttachmentName()));
            } else {
                aAttributes.put("href", link.getReference());
            }
        }
        this.getXHTMLWikiPrinter().printXMLStartElement(SPAN, spanAttributes);
        this.getXHTMLWikiPrinter().printXMLStartElement("a", aAttributes);
    }

    private void beginInternalLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        LinkedHashMap<String, String> spanAttributes = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> aAttributes = new LinkedHashMap<String, String>();
        aAttributes.putAll(parameters);
        if (StringUtils.isEmpty((String)link.getReference())) {
            this.renderAutoLink(link, spanAttributes, aAttributes);
        } else if (this.wikiModel.isDocumentAvailable(link.getReference())) {
            spanAttributes.put(CLASS, WIKILINK);
            aAttributes.put("href", this.wikiModel.getDocumentViewURL(link.getReference(), link.getAnchor(), link.getQueryString()));
        } else {
            spanAttributes.put(CLASS, "wikicreatelink");
            aAttributes.put("href", this.wikiModel.getDocumentEditURL(link.getReference(), link.getAnchor(), link.getQueryString()));
        }
        this.getXHTMLWikiPrinter().printXMLStartElement(SPAN, spanAttributes);
        this.getXHTMLWikiPrinter().printXMLStartElement("a", aAttributes);
    }

    private void renderAutoLink(Link link, Map<String, String> spanAttributes, Map<String, String> aAttributes) {
        spanAttributes.put(CLASS, WIKILINK);
        StringBuilder buffer = new StringBuilder();
        if (link.getQueryString() != null) {
            buffer.append('?');
            buffer.append(link.getQueryString());
        }
        buffer.append('#');
        if (link.getAnchor() != null) {
            buffer.append(link.getAnchor());
        }
        aAttributes.put("href", buffer.toString());
    }

    @Override
    public void endLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        if (!this.hasLabel) {
            this.getXHTMLWikiPrinter().printXMLStartElement(SPAN, new String[][]{{CLASS, "wikigeneratedlinkcontent"}});
            if (link.getType() == LinkType.DOCUMENT) {
                this.getXHTMLWikiPrinter().printXML(this.linkLabelGenerator.generate(link));
            } else if (link.getType() == LinkType.URI) {
                String label;
                int schemeSeparator = link.getReference().indexOf(":");
                if (schemeSeparator > -1) {
                    String scheme = link.getReference().substring(0, schemeSeparator);
                    try {
                        URILabelGenerator uriLabelGenerator = (URILabelGenerator)this.componentManager.lookup(URILabelGenerator.class, scheme);
                        label = uriLabelGenerator.generateLabel(link);
                    }
                    catch (ComponentLookupException e) {
                        label = link.getReference();
                    }
                } else {
                    label = link.getReference();
                }
                this.getXHTMLWikiPrinter().printXML(label);
            } else {
                this.getXHTMLWikiPrinter().printXML(link.getReference());
            }
            this.getXHTMLWikiPrinter().printXMLEndElement(SPAN);
        }
        this.getXHTMLWikiPrinter().printXMLEndElement("a");
        this.getXHTMLWikiPrinter().printXMLEndElement(SPAN);
    }
}

