/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.util.Matrix;

public class PDXObjectForm
extends PDXObject {
    public static final String SUB_TYPE = "Form";

    public PDXObjectForm(PDStream formStream) {
        super(formStream);
        this.getCOSStream().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public PDXObjectForm(COSStream formStream) {
        super(formStream);
        this.getCOSStream().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public int getFormType() {
        return this.getCOSStream().getInt("FormType", 1);
    }

    public void setFormType(int formType) {
        this.getCOSStream().setInt("FormType", formType);
    }

    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.getCOSStream().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        this.getCOSStream().setItem(COSName.RESOURCES, (COSObjectable)resources);
    }

    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSStream().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSStream().removeItem(COSName.BBOX);
        } else {
            this.getCOSStream().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }

    public Matrix getMatrix() {
        Matrix retval = null;
        COSArray array = (COSArray)this.getCOSStream().getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            retval = new Matrix();
            retval.setValue(0, 0, ((COSNumber)array.get(0)).floatValue());
            retval.setValue(0, 1, ((COSNumber)array.get(1)).floatValue());
            retval.setValue(1, 0, ((COSNumber)array.get(2)).floatValue());
            retval.setValue(1, 1, ((COSNumber)array.get(3)).floatValue());
            retval.setValue(2, 0, ((COSNumber)array.get(4)).floatValue());
            retval.setValue(2, 1, ((COSNumber)array.get(5)).floatValue());
        }
        return retval;
    }
}

