/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.rdbms;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestor;
import org.exoplatform.services.jcr.impl.core.BackupWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RdbmsWorkspaceInitializer
extends BackupWorkspaceInitializer {
    protected static final Log log = ExoLogger.getLogger("exo.jcr.component.core.RdbmsWorkspaceInitializer");
    protected final RepositoryService repositoryService;

    public RdbmsWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager, RepositoryService repositoryService, FileCleanerHolder cleanerHolder) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        super(config, repConfig, dataManager, namespaceRegistry, locationFactory, nodeTypeManager, valueFactory, accessManager, cleanerHolder);
        this.repositoryService = repositoryService;
    }

    public NodeData initWorkspace() throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        }
        long start = System.currentTimeMillis();
        this.restoreAction();
        NodeData root = (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        log.info("Workspace [" + this.workspaceName + "] restored from storage " + this.restorePath + " in " + (double)(System.currentTimeMillis() - start) * 1.0 / 1000.0 + "sec");
        return root;
    }

    protected void restoreAction() throws RepositoryException {
        this.fullRdbmsRestore();
    }

    protected void fullRdbmsRestore() throws RepositoryException {
        ArrayList<DataRestor> dataRestorers = new ArrayList<DataRestor>();
        ManageableRepository repository = null;
        try {
            repository = this.repositoryService.getRepository(this.repositoryEntry.getName());
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        List backupableComponents = repository.getWorkspaceContainer(this.workspaceName).getComponentInstancesOfType(Backupable.class);
        try {
            for (Backupable component : backupableComponents) {
                dataRestorers.add(component.getDataRestorer(new File(this.restorePath)));
            }
            for (DataRestor restorer : dataRestorers) {
                restorer.clean();
            }
            for (DataRestor restorer : dataRestorers) {
                restorer.restore();
            }
            for (DataRestor restorer : dataRestorers) {
                restorer.commit();
            }
        }
        catch (Throwable e) {
            for (DataRestor restorer : dataRestorers) {
                try {
                    restorer.rollback();
                }
                catch (BackupException e1) {
                    log.error("Can't rollback restorer", e);
                }
            }
            throw new RepositoryException(e);
        }
        finally {
            for (DataRestor restorer : dataRestorers) {
                try {
                    restorer.close();
                }
                catch (BackupException e) {
                    log.error("Can't close restorer", e);
                }
            }
        }
    }
}

