/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.bench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnswerDataInjector
extends DataInjector {
    private static Log log = ExoLogger.getLogger(AnswerDataInjector.class);
    private Map<String, String> fullNameData = new HashMap<String, String>();
    private int maxCategories = 3;
    private int maxDepth = 3;
    private int maxQuestions = 4;
    private int maxAnswers = 10;
    private int maxComments = 10;
    private int[] infoIject = new int[]{0, 0, 0, 0};
    private String SLASH = "/".intern();
    private boolean randomize = false;
    private Random rand;
    private Category categoryRoot = null;
    private FAQService faqService;
    private FAQSetting faqSetting = new FAQSetting();
    private List<String> categoryIds = new ArrayList<String>();

    public AnswerDataInjector(FAQService faqService, InitParams params) {
        this.faqService = faqService;
        this.initDatas();
        this.initParams(params);
    }

    private void initDatas() {
        this.rand = new Random();
        this.faqSetting.setDisplayMode("");
        this.faqSetting.setEmailSettingSubject("eXo Answers Notification");
        this.faqSetting.setEmailSettingContent("<p>We have a new question or answer by injector datas in category <strong>&categoryName_</strong></p><p><em>&questionContent_</em></p>");
        List<String> users = Arrays.asList("root", "demo", "mary", "john");
        List<String> userFullNames = Arrays.asList("Root Root", "Demo", "Mary Kelly", "John Anthony");
        for (int i = 0; i < users.size(); ++i) {
            this.fullNameData.put(users.get(i), userFullNames.get(i));
        }
    }

    public Log getLog() {
        return log;
    }

    private Category getCategoryRoot(boolean isUpdate) {
        try {
            if (isUpdate || this.categoryRoot == null) {
                this.categoryRoot = this.faqService.getCategoryById("categories");
            }
            return this.categoryRoot;
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getParam(InitParams initParams, String param, int df) throws Exception {
        try {
            return Integer.parseInt(initParams.getValueParam(param).getValue());
        }
        catch (Exception e) {
            return df;
        }
    }

    private boolean getParam(InitParams initParams, String param) throws Exception {
        try {
            return Boolean.parseBoolean(initParams.getValueParam(param).getValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void initParams(InitParams initParams) {
        try {
            this.maxCategories = this.getParam(initParams, "mCt", this.maxCategories);
            this.maxDepth = this.getParam(initParams, "mDt", this.maxDepth);
            this.maxQuestions = this.getParam(initParams, "mQs", this.maxQuestions);
            this.maxAnswers = this.getParam(initParams, "mAs", this.maxAnswers);
            this.maxComments = this.getParam(initParams, "mCm", this.maxComments);
            this.randomize = this.getParam(initParams, "rand");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize ", e);
        }
    }

    public boolean isInitialized() {
        return false;
    }

    private int getMaxItem(int maxType) {
        return this.randomize ? this.rand.nextInt(maxType) + 1 : maxType;
    }

    private List<Category> findCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        int maxCat = this.getMaxItem(this.maxCategories);
        if (maxCat > 0) {
            String previousId = "";
            for (int i = 0; i < maxCat; ++i) {
                Category cat = this.newCategory(previousId);
                categories.add(cat);
                previousId = cat.getId();
            }
        }
        return categories;
    }

    private List<Question> findQuestion(String catId) {
        ArrayList<Question> questions = new ArrayList<Question>();
        int maxQs = this.getMaxItem(this.maxQuestions);
        if (maxQs > 0) {
            for (int i = 0; i < maxQs; ++i) {
                questions.add(this.newQuestion(catId));
            }
        }
        return questions;
    }

    private Answer[] findAnswers() {
        int maxAs = this.getMaxItem(this.maxAnswers);
        Answer[] answers = new Answer[maxAs];
        if (maxAs > 0) {
            for (int i = 0; i < maxAs; ++i) {
                answers[i] = this.newAnswer();
            }
        }
        return answers;
    }

    private List<Comment> findComments() {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        int maxCm = this.getMaxItem(this.maxComments);
        if (maxCm > 0) {
            for (int i = 0; i < maxCm; ++i) {
                comments.add(this.newComment());
            }
        }
        return comments;
    }

    private String getTabs(int currentDepth) {
        String s = "";
        for (int i = 0; i < currentDepth; ++i) {
            s = s + "    ";
        }
        return s;
    }

    private void initDataForOneCategory(String parentId, Category cat, int currentDepth, int index, int size) throws Exception {
        String catId = parentId + this.SLASH + cat.getId();
        String s = this.getTabs(currentDepth);
        List<Question> questions = this.findQuestion(catId);
        int index_ = 0;
        int size_ = questions.size();
        log.info((Object)String.format(" %sCategory %s/%s with %s questions...", s, index, size, size_));
        this.faqService.saveCategory(parentId, cat, true);
        this.infoIject[0] = this.infoIject[0] + 1;
        this.infoIject[1] = this.infoIject[1] + size_;
        for (Question question : questions) {
            long t1 = System.currentTimeMillis();
            this.faqService.saveQuestion(question, true, this.faqSetting);
            String questionId = catId + this.SLASH + Utils.QUESTION_HOME + this.SLASH + question.getId();
            Answer[] answers = this.findAnswers();
            this.faqService.saveAnswer(questionId, answers);
            this.infoIject[2] = this.infoIject[2] + answers.length;
            List<Comment> comments = this.findComments();
            this.infoIject[3] = this.infoIject[3] + comments.size();
            for (Comment comment : comments) {
                this.faqService.saveComment(questionId, comment, true);
            }
            log.info((Object)String.format(" %s  Question %s/%s with %s answers and %s comments in %sms", s, ++index_, size_, answers.length, comments.size(), System.currentTimeMillis() - t1));
        }
    }

    private void createCategory(String parentId, Category me, int currentDepth, int index, int size) throws Exception {
        this.initDataForOneCategory(parentId, me, currentDepth, index, size);
        List<Category> cats = this.findCategories();
        int index_ = 1;
        int size_ = cats.size();
        for (Category cat : cats) {
            if (currentDepth + 1 >= this.maxDepth) continue;
            this.createCategory(parentId + this.SLASH + me.getId(), cat, currentDepth + 1, index_, size_);
            ++index_;
        }
    }

    public void inject() throws Exception {
        String parentId = "categories";
        this.infoIject = new int[]{0, 0, 0, 0};
        log.info((Object)"Start inject data for answer ....");
        long time = System.currentTimeMillis();
        List<Category> cats = this.findCategories();
        int size = cats.size();
        int index = 1;
        for (Category cat : cats) {
            this.categoryIds.add(parentId + this.SLASH + cat.getId());
            this.createCategory(parentId, cat, 0, index, size);
            ++index;
        }
        time = System.currentTimeMillis() - time;
        log.info((Object)String.format("INJECTED : categories=%s / questions=%s / answers=%s / comments=%s / time=%sms", this.infoIject[0], this.infoIject[1], this.infoIject[2], this.infoIject[3], time));
        this.saveHistoryInject();
    }

    private void removeData() throws Exception {
        try {
            if (this.categoryIds.isEmpty()) {
                this.categoryIds.addAll(this.getHistoryInject());
            }
            for (String categoryId : this.categoryIds) {
                this.faqService.removeCategory(categoryId);
            }
            log.info((Object)"Completely remove the datas inject !");
            this.categoryIds.clear();
            Category category = this.getCategoryRoot(false);
            category.setDescription("");
            this.faqService.saveCategory(null, category, false);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to remove data injected....");
        }
    }

    public void reject() throws Exception {
        log.info((Object)"Start remove data injected....");
        this.removeData();
    }

    private List<String> getHistoryInject() {
        try {
            return AnswerDataInjector.convertStringToList(this.getCategoryRoot(true).getDescription());
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    private void saveHistoryInject() {
        try {
            String s = this.getCategoryRoot(true).getDescription();
            if (s != null && s.trim().length() > 0) {
                this.categoryIds.addAll(AnswerDataInjector.convertStringToList(s));
            }
            Category category = this.getCategoryRoot(false);
            category.setDescription(this.categoryIds.toString());
            this.faqService.saveCategory(null, category, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> convertStringToList(String s) {
        s = s.replace("[", "").replace("]", "");
        s = s.trim().replaceAll("(,\\s*)", ",").replaceAll("(\\s*,)", ",");
        String[] strs = s.split(",");
        return new ArrayList<String>(Arrays.asList(strs));
    }

    private Category newCategory(String previousId) {
        Category category = new Category();
        while (category.getId().equals(previousId)) {
            category = new Category();
        }
        category.setName(this.randomWords(10));
        category.setDescription(this.randomWords(20));
        category.setIndex(0L);
        String[] mods = this.getCategoryRoot(false).getModerators();
        if (mods == null || mods.length == 0) {
            mods = new String[]{"root"};
        }
        category.setModerators(mods);
        category.setUserPrivate(new String[]{""});
        return category;
    }

    private Question newQuestion(String catId) {
        Question question = new Question();
        question.setAuthor(this.randomUser());
        question.setCategoryId(catId);
        question.setDetail(this.randomParagraphs(2));
        question.setEmail("exo@exoplatform.com");
        question.setLanguage("English");
        question.setLink("");
        question.setTopicIdDiscuss("");
        question.setMarkVote(0.0);
        question.setQuestion(this.randomWords(10));
        question.setRelations(new String[]{""});
        question.setUsersWatch(new String[]{""});
        question.setEmailsWatch(new String[]{""});
        return question;
    }

    private Answer newAnswer() {
        String other = this.randomUser();
        Answer answer = new Answer(other, true);
        answer.setFullName(this.getFullName(other));
        answer.setLanguage("English");
        answer.setMarksVoteAnswer(0.0);
        answer.setMarkVotes(0L);
        answer.setResponses(this.randomParagraphs(3));
        answer.setNew(true);
        return answer;
    }

    private Comment newComment() {
        String other = this.randomUser();
        Comment comment = new Comment();
        comment.setCommentBy(other);
        comment.setComments(this.randomParagraphs(3));
        comment.setFullName(this.getFullName(other));
        comment.setPostId("");
        comment.setNew(true);
        return comment;
    }

    private String getFullName(String userName) {
        try {
            return this.fullNameData.get(userName);
        }
        catch (Exception e) {
            return "No Name";
        }
    }
}

