/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.atom;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.util.atom.AtomEntry;
import org.apache.shindig.social.core.util.atom.AtomLink;

public class AtomFeed {
    private Collection<AtomEntry> entry;
    private int startIndex;
    private int totalResults;
    private int itemsPerPage;
    private String author;
    private AtomLink link;

    public AtomFeed(Object obj) {
        Preconditions.checkNotNull((Object)obj);
        if (obj instanceof Map) {
            Map m = (Map)obj;
            this.entry = Lists.newArrayList();
            for (Map.Entry o : m.entrySet()) {
                this.entry.add(new AtomEntry(o));
            }
            this.startIndex = 0;
            this.totalResults = this.entry.size();
            this.itemsPerPage = this.entry.size();
        } else if (obj instanceof RestfulCollection) {
            RestfulCollection r = (RestfulCollection)obj;
            this.entry = Lists.newArrayList();
            List entryList = r.getEntry();
            for (Object o : entryList) {
                this.entry.add(new AtomEntry(o));
            }
            this.startIndex = r.getStartIndex();
            this.totalResults = r.getTotalResults();
            this.itemsPerPage = r.getItemsPerPage();
            this.author = "?";
            this.link = new AtomLink("rel", "???");
        } else if (obj instanceof DataCollection) {
            DataCollection dc = (DataCollection)obj;
            this.entry = Lists.newArrayList();
            for (Map.Entry o : dc.getEntry().entrySet()) {
                this.entry.add(new AtomEntry(o));
            }
            this.startIndex = 0;
            this.totalResults = this.entry.size();
            this.itemsPerPage = this.entry.size();
        } else {
            this.entry = ImmutableList.of((Object)new AtomEntry(obj));
            this.startIndex = 0;
            this.totalResults = 1;
            this.itemsPerPage = 1;
        }
    }
}

