/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "kl" locale.
 */
public class LocalizedNamesImpl_kl extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AE",
        "AF",
        "AI",
        "AX",
        "AL",
        "DZ",
        "AN",
        "AD",
        "AO",
        "AG",
        "AR",
        "AM",
        "AW",
        "AS",
        "AU",
        "AZ",
        "BS",
        "BH",
        "BB",
        "BD",
        "BE",
        "BZ",
        "BM",
        "BJ",
        "BL",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BT",
        "BG",
        "BF",
        "MM",
        "BI",
        "BV",
        "CA",
        "CV",
        "CC",
        "EA",
        "CF",
        "TD",
        "CI",
        "CK",
        "CL",
        "CP",
        "CM",
        "CO",
        "CR",
        "CY",
        "DK",
        "DG",
        "DJ",
        "DO",
        "DM",
        "EC",
        "EG",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FJ",
        "FI",
        "FR",
        "GA",
        "GM",
        "GE",
        "GF",
        "GH",
        "GI",
        "GQ",
        "GR",
        "GD",
        "GS",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "NL",
        "HN",
        "HK",
        "HR",
        "BY",
        "IM",
        "IN",
        "ID",
        "IO",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "CX",
        "GL",
        "KH",
        "IC",
        "KZ",
        "KE",
        "KG",
        "CN",
        "KI",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CU",
        "KW",
        "KY",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MG",
        "MK",
        "MW",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "MH",
        "FM",
        "MN",
        "MZ",
        "MD",
        "MC",
        "ME",
        "MS",
        "MP",
        "MV",
        "US",
        "NA",
        "NR",
        "NP",
        "NF",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PH",
        "PN",
        "PL",
        "PT",
        "PS",
        "PR",
        "AQ",
        "QO",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "EH",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "WS",
        "SM",
        "ST",
        "SA",
        "FO",
        "SB",
        "SC",
        "CH",
        "SN",
        "RS",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "SD",
        "SR",
        "SJ",
        "SE",
        "SZ",
        "SY",
        "TW",
        "TJ",
        "TZ",
        "TC",
        "TF",
        "TH",
        "TL",
        "CZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "GB",
        "TN",
        "TM",
        "TV",
        "TR",
        "DE",
        "UG",
        "UA",
        "UM",
        "HU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "WF",
        "ZA",
        "ZM",
        "ZW",
        "AT",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "silarsuaq");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Amerika Avannarleq");
    namesMap.put("005", "Amerika Kujalleq");
    namesMap.put("011", "Afrika Killiit");
    namesMap.put("013", "America Qitiusumik");
    namesMap.put("014", "Afrika Kangilliit");
    namesMap.put("015", "Afrika Avannarleq");
    namesMap.put("017", "Afrika Qitiusumik");
    namesMap.put("019", "Amerika");
    namesMap.put("030", "Asia Kangilliit");
    namesMap.put("034", "Asia Kujalleq");
    namesMap.put("039", "Europa Kujalleq");
    namesMap.put("053", "Australia aamma Nutaaq Zeeland");
    namesMap.put("143", "Asia Qitiusumik");
    namesMap.put("145", "Asia Killiit");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa Kangilliit");
    namesMap.put("154", "Europa Avannarleq");
    namesMap.put("155", "Europa Killiit");
    namesMap.put("419", "America Latin aamma Karibia");
    namesMap.put("AG", "Antigua aamma Barbuda");
    namesMap.put("AQ", "Qalasersuaq Kujalleq");
    namesMap.put("AT", "Østrigi");
    namesMap.put("AX", "Ålandi");
    namesMap.put("BA", "Bosnia aamma Herzegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BR", "Brasilien");
    namesMap.put("BY", "Hvideruslandi");
    namesMap.put("CD", "Kongo-Kinshasa");
    namesMap.put("CG", "Kongo-Brazzaville");
    namesMap.put("CH", "Schweizi");
    namesMap.put("CN", "Kina");
    namesMap.put("CP", "Clipperton qeqertaq");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Cap Verde");
    namesMap.put("CX", "Jul-qeqertaq");
    namesMap.put("CZ", "Tjekkia");
    namesMap.put("DE", "Tysklandi");
    namesMap.put("DK", "Danmarki");
    namesMap.put("DZ", "Algeriet");
    namesMap.put("EA", "Ceuta aamma Melilla");
    namesMap.put("EE", "Estlandi");
    namesMap.put("EG", "Egypten");
    namesMap.put("EH", "Sahara Killiit");
    namesMap.put("ES", "Spania");
    namesMap.put("EU", "Europami nunat kattusimaffiat");
    namesMap.put("FI", "Finlandi");
    namesMap.put("FK", "Falklandi qeqertaq");
    namesMap.put("FO", "Savalimmiut");
    namesMap.put("FR", "Frankrigi");
    namesMap.put("GB", "Tuluit Nunaat");
    namesMap.put("GL", "Kalaallit Nunaat");
    namesMap.put("GR", "Grækenlandi");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HU", "Ungarni");
    namesMap.put("IC", "Kanaria qeqertaq");
    namesMap.put("IE", "Irlandi");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islandi");
    namesMap.put("IT", "Italia");
    namesMap.put("JP", "Japani");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KN", "Saint Kitts aamma Nevis");
    namesMap.put("KP", "Korea Avannarleq");
    namesMap.put("KR", "Korea Kujalleq");
    namesMap.put("KZ", "Kasakhstani");
    namesMap.put("LB", "Libanon");
    namesMap.put("LT", "Litaueni");
    namesMap.put("LV", "Letlandi");
    namesMap.put("MA", "Marocko");
    namesMap.put("MD", "Moldavia");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MM", "Burma");
    namesMap.put("MO", "Macao");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MZ", "Moçambique");
    namesMap.put("NC", "Nutaaq Caledonia");
    namesMap.put("NL", "Hollandi");
    namesMap.put("NO", "Norge");
    namesMap.put("NZ", "Nutaaq Zeeland");
    namesMap.put("PG", "Papua Nutaaq Guinea");
    namesMap.put("PL", "Poleni");
    namesMap.put("PM", "Saint Pierre aamma Miquelon");
    namesMap.put("PT", "Portugali");
    namesMap.put("QA", "Quatar");
    namesMap.put("RO", "Rumænia");
    namesMap.put("RU", "Ruslandi");
    namesMap.put("SE", "Sverige");
    namesMap.put("SJ", "Svalbard aamma Jan Mayen");
    namesMap.put("ST", "São Tomé aamma Príncipe");
    namesMap.put("SZ", "Swazilandi");
    namesMap.put("TH", "Thailandi");
    namesMap.put("TL", "Timor Kangilliit");
    namesMap.put("TM", "Turkmenistani");
    namesMap.put("TR", "Tyrkia");
    namesMap.put("TT", "Trinidad aamma Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("US", "Naalagaaffeqatigiit");
    namesMap.put("UZ", "Uzbekistani");
    namesMap.put("VA", "Vatikani");
    namesMap.put("WF", "Wallis aamma Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZZ", "atorsinnaanngitsoq sinerissap ilaa aalajangersimasoq");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "silarsuaq",
        "002": "Afrika",
        "003": "Amerika Avannarleq",
        "005": "Amerika Kujalleq",
        "011": "Afrika Killiit",
        "013": "America Qitiusumik",
        "014": "Afrika Kangilliit",
        "015": "Afrika Avannarleq",
        "017": "Afrika Qitiusumik",
        "019": "Amerika",
        "030": "Asia Kangilliit",
        "034": "Asia Kujalleq",
        "039": "Europa Kujalleq",
        "053": "Australia aamma Nutaaq Zeeland",
        "143": "Asia Qitiusumik",
        "145": "Asia Killiit",
        "150": "Europa",
        "151": "Europa Kangilliit",
        "154": "Europa Avannarleq",
        "155": "Europa Killiit",
        "419": "America Latin aamma Karibia",
        "AG": "Antigua aamma Barbuda",
        "AQ": "Qalasersuaq Kujalleq",
        "AT": "Østrigi",
        "AX": "Ålandi",
        "BA": "Bosnia aamma Herzegovina",
        "BE": "Belgia",
        "BR": "Brasilien",
        "BY": "Hvideruslandi",
        "CD": "Kongo-Kinshasa",
        "CG": "Kongo-Brazzaville",
        "CH": "Schweizi",
        "CN": "Kina",
        "CP": "Clipperton qeqertaq",
        "CU": "Kuba",
        "CV": "Cap Verde",
        "CX": "Jul-qeqertaq",
        "CZ": "Tjekkia",
        "DE": "Tysklandi",
        "DK": "Danmarki",
        "DZ": "Algeriet",
        "EA": "Ceuta aamma Melilla",
        "EE": "Estlandi",
        "EG": "Egypten",
        "EH": "Sahara Killiit",
        "ES": "Spania",
        "EU": "Europami nunat kattusimaffiat",
        "FI": "Finlandi",
        "FK": "Falklandi qeqertaq",
        "FO": "Savalimmiut",
        "FR": "Frankrigi",
        "GB": "Tuluit Nunaat",
        "GL": "Kalaallit Nunaat",
        "GR": "Grækenlandi",
        "HK": "Hongkong",
        "HU": "Ungarni",
        "IC": "Kanaria qeqertaq",
        "IE": "Irlandi",
        "IQ": "Irak",
        "IS": "Islandi",
        "IT": "Italia",
        "JP": "Japani",
        "KH": "Kambodia",
        "KN": "Saint Kitts aamma Nevis",
        "KP": "Korea Avannarleq",
        "KR": "Korea Kujalleq",
        "KZ": "Kasakhstani",
        "LB": "Libanon",
        "LT": "Litaueni",
        "LV": "Letlandi",
        "MA": "Marocko",
        "MD": "Moldavia",
        "MG": "Madagaskar",
        "MK": "Makedonia",
        "MM": "Burma",
        "MO": "Macao",
        "MX": "Mexiko",
        "MZ": "Moçambique",
        "NC": "Nutaaq Caledonia",
        "NL": "Hollandi",
        "NO": "Norge",
        "NZ": "Nutaaq Zeeland",
        "PG": "Papua Nutaaq Guinea",
        "PL": "Poleni",
        "PM": "Saint Pierre aamma Miquelon",
        "PT": "Portugali",
        "QA": "Quatar",
        "RO": "Rumænia",
        "RU": "Ruslandi",
        "SE": "Sverige",
        "SJ": "Svalbard aamma Jan Mayen",
        "ST": "São Tomé aamma Príncipe",
        "SZ": "Swazilandi",
        "TH": "Thailandi",
        "TL": "Timor Kangilliit",
        "TM": "Turkmenistani",
        "TR": "Tyrkia",
        "TT": "Trinidad aamma Tobago",
        "UA": "Ukraina",
        "US": "Naalagaaffeqatigiit",
        "UZ": "Uzbekistani",
        "VA": "Vatikani",
        "WF": "Wallis aamma Futuna",
        "YE": "Jemen",
        "ZZ": "atorsinnaanngitsoq sinerissap ilaa aalajangersimasoq"
    };
  }-*/;
}
