/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.section.column;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.inject.Inject;
import org.exoplatform.wiki.rendering.macro.section.column.ColumnMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="column")
public class ColumnMacro<P extends ColumnMacroParameters>
extends AbstractMacro<P> {
    @Inject
    private ComponentManager componentManager;
    private static final String MACRO_NAME = "Column";
    private static final String DESCRIPTION = "declares a column in a columned section";

    public ColumnMacro() {
        super(MACRO_NAME, DESCRIPTION, ColumnMacroParameters.class);
    }

    public List<Block> execute(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM parsedDom;
        Parser parser = this.getSyntaxParser(context.getSyntax().toIdString());
        try {
            parsedDom = parser.parse((Reader)new StringReader(content));
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "] with Syntax parser [" + parser.getSyntax() + "]", (Throwable)e);
        }
        List result = parsedDom.getChildren();
        return result;
    }

    protected Parser getSyntaxParser(String syntaxId) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.getInstance(Parser.class, syntaxId);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser", (Throwable)e);
        }
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public int getPriority() {
        return 750;
    }
}

