/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;

public class SpaceReference
extends EntityReference {
    public SpaceReference(EntityReference reference) {
        super(reference.getName(), reference.getType(), reference.getParent());
    }

    public SpaceReference(String spaceName, SpaceReference parent) {
        super(spaceName, EntityType.SPACE, parent);
    }

    public SpaceReference(String spaceName, WikiReference parent) {
        super(spaceName, EntityType.SPACE, parent);
    }

    public void setParent(EntityReference parent) {
        if (parent == null || parent.getType() != EntityType.SPACE && parent.getType() != EntityType.WIKI) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] for a space reference");
        }
        if (parent.getType() == EntityType.SPACE) {
            super.setParent(new SpaceReference(parent));
        } else {
            super.setParent(new WikiReference(parent));
        }
    }

    public void setType(EntityType type) {
        if (type != EntityType.SPACE) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for a space reference");
        }
        super.setType(EntityType.SPACE);
    }
}

