/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DefaultStringEntityReferenceSerializer
implements EntityReferenceSerializer<String> {
    private Map<EntityType, List<String>> escapes = new HashMap<EntityType, List<String>>(){
        {
            this.put(EntityType.ATTACHMENT, Arrays.asList("@"));
            this.put(EntityType.DOCUMENT, Arrays.asList("."));
            this.put(EntityType.SPACE, Arrays.asList(":", "."));
            this.put(EntityType.OBJECT, Arrays.asList("^"));
            this.put(EntityType.OBJECT_PROPERTY, Arrays.asList("."));
        }
    };
    private Map<EntityType, List<String>> replacements = new HashMap<EntityType, List<String>>(){
        {
            this.put(EntityType.ATTACHMENT, Arrays.asList("\\@"));
            this.put(EntityType.DOCUMENT, Arrays.asList("\\."));
            this.put(EntityType.SPACE, Arrays.asList("\\:", "\\."));
            this.put(EntityType.OBJECT, Arrays.asList("\\^"));
            this.put(EntityType.OBJECT_PROPERTY, Arrays.asList("\\."));
        }
    };

    @Override
    public String serialize(EntityReference reference, Object ... parameters) {
        if (reference == null) {
            return null;
        }
        StringBuilder representation = new StringBuilder();
        for (EntityReference currentReference = reference.getRoot(); currentReference != null && currentReference != reference.getChild(); currentReference = currentReference.getChild()) {
            this.serializeEntityReference(currentReference, representation, currentReference == reference, parameters);
        }
        return representation.toString();
    }

    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        List<String> currentEscapeChars = this.escapes.get((Object)currentReference.getType());
        if (currentEscapeChars != null) {
            representation.append(StringUtils.replaceEach((String)currentReference.getName(), (String[])currentEscapeChars.toArray(new String[0]), (String[])this.replacements.get((Object)currentReference.getType()).toArray(new String[0])));
        } else {
            representation.append(currentReference.getName());
        }
        if (!isLastReference && currentReference.getChild() != null) {
            String separatorChar = this.escapes.get((Object)currentReference.getChild().getType()).get(0);
            representation.append(separatorChar);
        }
    }
}

