/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.converter;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.wiki.rendering.converter.ObjectReferenceConverter;
import org.xwiki.component.annotation.Component;

@Component(value="confluence/1.0")
public class ConfluenceObjectReferenceConverter
implements ObjectReferenceConverter {
    public static final String wikiPageSeparator = ":";
    public static final String spaceSeparator = ".";

    public String convert(String objectReference) {
        int wikiIndex = objectReference.indexOf(wikiPageSeparator);
        if (wikiIndex > 0) {
            String space = objectReference.substring(0, wikiIndex);
            String pageName = objectReference.substring(wikiIndex + 1);
            int spaceIndex = objectReference.indexOf(spaceSeparator);
            if (spaceIndex > 0) {
                String spaceType = space.substring(0, spaceIndex);
                String spaceName = space.substring(spaceIndex + 1);
                space = spaceType + wikiPageSeparator + spaceName;
            }
            pageName = StringUtils.replace((String)pageName, (String)spaceSeparator, (String)"\\.");
            return space + spaceSeparator + pageName;
        }
        return StringUtils.replace((String)objectReference, (String)spaceSeparator, (String)"\\.");
    }
}

