/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class DiscardTest
extends ChannelTestBase {
    JChannel ch1;
    JChannel ch2;
    static final long NUM_MSGS = 10000L;
    static final int MSG_SIZE = 1000;
    private static final String GROUP = "DiscardTestGroup";
    final Promise<Long> ch1_all_received = new Promise();
    final Promise<Long> ch2_all_received = new Promise();

    public DiscardTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ch1_all_received.reset();
        this.ch2_all_received.reset();
    }

    @Override
    protected void tearDown() throws Exception {
        this.ch2.close();
        this.ch1.close();
        super.tearDown();
    }

    public void testDiscardProperties() throws Exception {
        this._testLosslessReception(true);
    }

    public void testFastProperties() throws Exception {
        this._testLosslessReception(false);
    }

    public void _testLosslessReception(boolean discard) throws Exception {
        this.ch1 = this.createChannel();
        this.ch1.setReceiver(new MyReceiver(this.ch1_all_received, 10000L, "ch1"));
        this.ch2 = this.createChannel();
        this.ch2.setReceiver(new MyReceiver(this.ch2_all_received, 10000L, "ch2"));
        if (discard) {
            DISCARD discard_prot = new DISCARD();
            Properties properties = new Properties();
            properties.setProperty("down", "0.1");
            this.ch1.getProtocolStack().insertProtocol((Protocol)discard_prot, 2, "MERGE2");
            discard_prot = new DISCARD();
            properties = new Properties();
            properties.setProperty("down", "0.1");
            this.ch2.getProtocolStack().insertProtocol((Protocol)discard_prot, 2, "MERGE2");
        }
        this.ch1.connect(GROUP);
        Address ch1_addr = this.ch1.getLocalAddress();
        this.ch2.connect(GROUP);
        Address ch2_addr = this.ch2.getLocalAddress();
        Util.sleep(2000L);
        View v = this.ch2.getView();
        System.out.println("**** ch2's view: " + v);
        DiscardTest.assertEquals((int)2, (int)v.size());
        DiscardTest.assertTrue((boolean)v.getMembers().contains(ch1_addr));
        DiscardTest.assertTrue((boolean)v.getMembers().contains(ch2_addr));
        System.out.println("sending 10000 1K messages to all members (including myself)");
        long start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < 10000L) {
            Message msg = DiscardTest.createMessage(1000);
            this.ch1.send(msg);
            if (i % 1000 == 0) {
                System.out.println("-- sent " + i + " messages");
            }
            ++i;
        }
        System.out.println("-- waiting for ch1 and ch2 to receive 10000 messages");
        Long num_msgs = this.ch1_all_received.getResult();
        System.out.println("-- received " + num_msgs + " messages on ch1");
        num_msgs = this.ch2_all_received.getResult();
        long stop = System.currentTimeMillis();
        System.out.println("-- received " + num_msgs + " messages on ch2");
        long diff = stop - start;
        double msgs_sec = 10000.0 / ((double)diff / 1000.0);
        System.out.println("== Sent and received 10000 in " + diff + "ms, " + msgs_sec + " msgs/sec");
    }

    private static Message createMessage(int size) {
        byte[] buf = new byte[size];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 120;
        }
        return new Message(null, null, buf);
    }

    public static Test suite() {
        return new TestSuite(DiscardTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DiscardTest.suite());
    }

    static class MyReceiver
    extends ReceiverAdapter {
        final Promise<Long> p;
        final long num_msgs_expected;
        long num_msgs = 0L;
        String channel_name;
        boolean operational = true;

        public MyReceiver(Promise<Long> p, long num_msgs_expected, String channel_name) {
            this.p = p;
            this.num_msgs_expected = num_msgs_expected;
            this.channel_name = channel_name;
        }

        @Override
        public void receive(Message msg) {
            if (!this.operational) {
                return;
            }
            ++this.num_msgs;
            if (this.num_msgs > 0L && this.num_msgs % 1000L == 0L) {
                System.out.println("-- received " + this.num_msgs + " on " + this.channel_name);
            }
            if (this.num_msgs >= this.num_msgs_expected) {
                System.out.println("SUCCESS: received all " + this.num_msgs_expected + " messages on " + this.channel_name);
                this.operational = false;
                this.p.setResult(new Long(this.num_msgs));
            }
        }

        @Override
        public void viewAccepted(View new_view) {
            System.out.println("-- view (" + this.channel_name + "): " + new_view);
        }
    }
}

