/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.textcolor;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.exoplatform.wiki.rendering.macro.textcolor.ColorMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="color")
public class ColorMacro
extends AbstractMacro<ColorMacroParameters> {
    @Inject
    private ComponentManager componentManager;
    private static final String DESCRIPTION = "Decorate text with color";

    public ColorMacro() {
        super("Color", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(), ColorMacroParameters.class);
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(ColorMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM parsedDom;
        String color = parameters.getName();
        Parser parser = this.getSyntaxParser(context.getSyntax().toIdString());
        try {
            parsedDom = parser.parse((Reader)new StringReader(content));
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "] with Syntax parser [" + parser.getSyntax() + "]", (Throwable)e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", "color:" + color + ";");
        ArrayList children = new ArrayList();
        children.addAll(parsedDom.getChildren());
        new ParserUtils().removeTopLevelParagraph(children);
        FormatBlock spanBlock = new FormatBlock(children, Format.NONE, params);
        return Collections.singletonList(spanBlock);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected Parser getSyntaxParser(String syntaxId) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.lookup(Parser.class, syntaxId);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser", (Throwable)e);
        }
    }
}

