/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.document.impl.XMLDocumentReader");

    public String[] getMimeTypes() {
        return new String[]{"text/xml", "application/xml", "application/x-google-gadget"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        try {
            String string = this.parse(is);
            return string;
        }
        finally {
            block9: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block9;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        block2: {
            try {
                is.close();
            }
            catch (IOException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return new Properties();
    }

    private String parse(InputStream is) {
        final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        StringWriter writer = new StringWriter();
        WriteOutContentHandler dh = new WriteOutContentHandler(writer);
        try {
            SAXParser saxParser = (SAXParser)SecurityHelper.doPrivilegedParserConfigurationOrSAXExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<SAXParser>(){

                @Override
                public SAXParser run() throws Exception {
                    return saxParserFactory.newSAXParser();
                }
            });
            saxParser.parse(is, (DefaultHandler)dh);
        }
        catch (SAXException e) {
            return "";
        }
        catch (IOException e) {
            return "";
        }
        catch (ParserConfigurationException e) {
            return "";
        }
        return writer.toString();
    }

    class WriteOutContentHandler
    extends DefaultHandler {
        private final Writer writer;

        public WriteOutContentHandler(Writer writer) {
            this.writer = writer;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.writer.write(ch, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }

        public void endDocument() throws SAXException {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }
}

