/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.HashMap;
import java.util.Map;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.core.AbstractTypeInfo;
import org.reflext.core.ArrayTypeInfoImpl;
import org.reflext.core.ClassTypeInfoImpl;
import org.reflext.core.ParameterizedTypeInfoImpl;
import org.reflext.core.SimpleTypeInfoImpl;
import org.reflext.core.TypeVariableInfoImpl;
import org.reflext.core.VoidTypeInfoImpl;
import org.reflext.core.WildcardTypeInfoImpl;
import org.reflext.spi.model.AnnotationModel;
import org.reflext.spi.model.FieldModel;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.ReflectionModel;
import org.reflext.spi.model.TypeKind;
import org.reflext.spi.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeResolverImpl<T, M, A, P, F>
implements TypeResolver<T> {
    final TypeModel<T> typeModel;
    final FieldModel<T, F> fieldModel;
    final MethodModel<T, M> methodModel;
    final AnnotationModel<T, T, A, P> typeAnnotationModel;
    final AnnotationModel<T, F, A, P> fieldAnnotationModel;
    final AnnotationModel<T, M, A, P> methodAnnotationModel;
    final Map<T, AbstractTypeInfo<T, M, A, P, F>> cache;

    public static <T, M, A, P, F> TypeResolver<T> create(ReflectionModel<T, M, A, P, F> model) {
        return new TypeResolverImpl<T, M, A, P, F>(model, true);
    }

    public static <T, M, A, P, F> TypeResolver<T> create(ReflectionModel<T, M, A, P, F> model, boolean cache) {
        return new TypeResolverImpl<T, M, A, P, F>(model, cache);
    }

    private TypeResolverImpl(ReflectionModel<T, M, A, P, F> model, boolean cache) {
        this.typeModel = model.getTypeModel();
        this.fieldModel = model.getFieldModel();
        this.methodModel = model.getMethodModel();
        this.typeAnnotationModel = model.getTypeAnnotationModel();
        this.fieldAnnotationModel = model.getFieldAnnotationModel();
        this.methodAnnotationModel = model.getMethodAnnotationModel();
        this.cache = cache ? new HashMap() : null;
    }

    public TypeInfo resolve(T type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        return this._getType(type);
    }

    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    AbstractTypeInfo<T, M, A, P, F> _getType(T type) {
        if (this.cache == null) {
            return this.build(type);
        }
        AbstractTypeInfo<T, M, A, P, F> cached = this.cache.get(type);
        if (cached == null) {
            cached = this.build(type);
            this.cache.put(type, cached);
        }
        return cached;
    }

    private AbstractTypeInfo<T, M, A, P, F> build(T type) {
        TypeKind kind = this.typeModel.getKind(type);
        switch (kind) {
            case SIMPLE: {
                return new SimpleTypeInfoImpl(this, type);
            }
            case VOID: {
                return new VoidTypeInfoImpl(this, type);
            }
            case CLASS: {
                return new ClassTypeInfoImpl(this, type);
            }
            case PARAMETERIZED: {
                return new ParameterizedTypeInfoImpl(this, type);
            }
            case VARIABLE: {
                return new TypeVariableInfoImpl(this, type);
            }
            case WILDCARD: {
                return new WildcardTypeInfoImpl(this, type);
            }
            case ARRAY: {
                return new ArrayTypeInfoImpl(this, type);
            }
        }
        throw new AssertionError((Object)("Cannot handle type " + type + " with kind " + kind));
    }
}

