/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.test;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import junit.framework.TestCase;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.jmx.ManagementContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.ks.test.mock.SimpleMockOrganizationService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.impl.CacheServiceImpl;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.IdentityRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerBasedTestCase
extends TestCase {
    protected SimpleMockOrganizationService organizationService = null;
    protected CacheService cacheService = null;
    protected IdentityRegistry identityRegistry = null;

    public final void setUp() throws Exception {
        this.cacheService = this.initCacheService();
        this.identityRegistry = this.initIdentityRegistry();
        this.organizationService = new SimpleMockOrganizationService();
        ExoContainer testContainer = new ExoContainer(new ManagementContextImpl(ManagementFactory.getPlatformMBeanServer(), new HashMap()));
        this.registerDefaultComponents(testContainer);
        this.registerComponents(testContainer);
        ExoContainerContext.setCurrentContainer((ExoContainer)testContainer);
        this.doSetUp();
    }

    private void registerDefaultComponents(ExoContainer testContainer) {
        testContainer.registerComponentInstance(OrganizationService.class, (Object)this.organizationService);
        testContainer.registerComponentInstance(IdentityRegistry.class, (Object)this.identityRegistry);
        testContainer.registerComponentInstance(CacheService.class, (Object)this.cacheService);
    }

    protected <T, I extends T> void registerComponent(Class<T> clazz, I impl) {
        ExoContainerContext.getCurrentContainer().registerComponentImplementation(impl, clazz);
    }

    protected abstract void registerComponents(ExoContainer var1);

    protected void doSetUp() {
    }

    protected CacheService initCacheService() throws Exception {
        InitParams cacheParams = new InitParams();
        ObjectParameter oparam = new ObjectParameter();
        ExoCacheConfig config = new ExoCacheConfig();
        oparam.setName("cache.config.default");
        config.setName("default");
        config.setMaxSize(30);
        config.setLiveTime(300L);
        config.setDistributed(false);
        config.setImplementation("org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache");
        oparam.setObject((Object)config);
        cacheParams.addParameter((Parameter)oparam);
        return new CacheServiceImpl(cacheParams);
    }

    protected IdentityRegistry initIdentityRegistry() {
        return new IdentityRegistry(null);
    }
}

