/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.ks.forum;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.webservice.ks.forum.BanIP;
import org.exoplatform.webservice.ks.forum.BeanToJsons;
import org.exoplatform.webservice.ks.forum.MessageBean;

public class ForumWebservice
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    private String strQuery;
    private List<BanIP> ipsToJson = new ArrayList<BanIP>();

    @GET
    @Path(value="/ks/forum/getmessage/{maxcount}/")
    @Produces(value={"application/json"})
    public Response getMessage(@PathParam(value="maxcount") String maxcount) throws Exception {
        int counter = 0;
        try {
            counter = Integer.parseInt(maxcount);
        }
        catch (Exception e) {
            // empty catch block
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        List list = forumService.getNewPosts(counter);
        ArrayList<MessageBean> lastMessages = new ArrayList<MessageBean>();
        if (!list.isEmpty()) {
            for (Post post : list) {
                lastMessages.add(new MessageBean(post));
            }
        }
        return Response.ok(new BeanToJsons(lastMessages), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/ks/forum/filter/{strIP}/")
    @Produces(value={"application/json"})
    public Response filterIps(@PathParam(value="strIP") String str) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List banIps = forumService.getBanList();
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List banIps = forumService.getBanList();
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
            this.strQuery = str;
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/ks/forum/filterIpBanforum/{strForumId}/{strIP}/")
    @Produces(value={"application/json"})
    public Response filterIpBanForum(@PathParam(value="strForumId") String forumId, @PathParam(value="strIP") String str) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
            this.strQuery = str;
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/ks/forum/filterTagNameForum/{userAndTopicId}/{strTagName}/")
    @Produces(value={"application/json"})
    public Response filterTagNameForum(@PathParam(value="strTagName") String str, @PathParam(value="userAndTopicId") String userAndTopicId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals(" ")) {
            this.ipsToJson.clear();
        } else if (str.equals("onclickForm")) {
            this.ipsToJson.clear();
            List banIps = forumService.getTagNameInTopic(userAndTopicId);
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else {
            this.ipsToJson.clear();
            List banIps = forumService.getAllTagName(str, userAndTopicId);
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }
}

