/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.xmpp.bean.CometdMessageBean;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.connection.impl.XMPPSessionImpl;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.BeanBuilder;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.jivesoftware.smack.packet.Presence;
import org.mortbay.cometd.continuation.EXoContinuationClient;

public class CometdFilter
implements Filter {
    protected static final Log LOGGER = ExoLogger.getLogger((String)"CometdFilter");

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        XMPPMessenger messenger = this.getXMPPMessenger();
        ContinuationService continuation = this.getContinuationService();
        boolean b = false;
        EXoContinuationClient client = null;
        if (messenger == null) {
            LOGGER.error((Object)"XMPPMessenger is null");
        }
        if (continuation == null) {
            LOGGER.error((Object)"ContinuationService is null");
        }
        if (messenger != null && continuation != null) {
            JsonParserImpl jsonParser = new JsonParserImpl();
            JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
            String jsonString = request.getParameter("message");
            if (jsonString.startsWith("[") && jsonString.endsWith("]")) {
                jsonString = jsonString.substring(1, jsonString.length() - 1);
            }
            CometdMessageBean bean = new CometdMessageBean();
            System.out.println(jsonString);
            try {
                jsonParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(jsonString.getBytes())), (JsonHandler)jsonHandler);
                JsonValue jv = jsonHandler.getJsonObject();
                bean = new CometdMessageBean();
                bean = (CometdMessageBean)new BeanBuilder().createObject(CometdMessageBean.class, jv);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println(bean.getClientId());
            client = continuation.getClient(bean.getClientId());
            if (client != null) {
                String exoId = client.getEXoId();
                LOGGER.info((Object)("Get exoId : " + exoId));
                if (exoId != null && bean.getChannel().equals("/meta/connect") && bean.getConnectionType().equals("long-polling")) {
                    b = true;
                    XMPPSessionImpl session = (XMPPSessionImpl)messenger.getSession(exoId);
                    session.setAlive_(true);
                    session.setAwayTime(System.currentTimeMillis());
                    if (session.getPresence().getType().equals((Object)Presence.Type.unavailable)) {
                        session.sendPresence(new Presence(Presence.Type.available));
                        session.setPresence(new Presence(Presence.Type.available));
                    }
                }
            }
        }
        chain.doFilter(request, response);
        if (b) {
            XMPPSessionImpl session = (XMPPSessionImpl)messenger.getSession(client.getEXoId());
            session.setAlive_(false);
            session.setAwayTime(System.currentTimeMillis());
            session.startAliveChecker();
        }
    }

    protected ContinuationService getContinuationService() {
        RootContainer container = RootContainer.getInstance();
        container = container.getPortalContainer("portal");
        ContinuationService continuation = (ContinuationService)container.getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    protected XMPPMessenger getXMPPMessenger() {
        RootContainer container = RootContainer.getInstance();
        container = container.getPortalContainer("portal");
        XMPPMessenger messenger = (XMPPMessenger)container.getComponentInstanceOfType(XMPPMessenger.class);
        return messenger;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

