/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.html;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.rest.RESTOrganizationServiceAbstractImpl;
import org.exoplatform.services.organization.rest.xml.RESTOrganizationServiceXMLImpl;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;
import org.exoplatform.services.rest.transformer.SerializableEntity;
import org.exoplatform.services.rest.transformer.SerializableTransformer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;
import org.exoplatform.services.rest.transformer.XSLT4SourceOutputTransformer;

@URITemplate(value="/organization/")
public class RESTOrganizationServiceHTMLImpl
extends RESTOrganizationServiceAbstractImpl
implements ResourceContainer {
    private static final Log LOGGER = ExoLogger.getLogger(RESTOrganizationServiceHTMLImpl.class);
    RESTOrganizationServiceXMLImpl xmlImpl;
    protected static final String GROUP_INFO_SCHEMA = "group-info";
    protected static final String GROUP_EDIT_SCHEMA = "group-edit";
    protected static final String GROUPS_LIST_SCHEMA = "groups-list";
    protected static final String GROUPS_LIST_FRAGMENT_SCHEMA = "groups-list-fragment";
    protected static final String USER_INFO_SCHEMA = "user-info";
    protected static final String USERS_LIST_SCHEMA = "users-list";
    protected static final String USERS_LIST_SEARCH_SCHEMA = "users-list-search";
    protected static final String MEMBERSHIP_LIST_SCHEMA = "memberships-list";

    public RESTOrganizationServiceHTMLImpl(OrganizationService organizationService) {
        super(organizationService);
        this.xmlImpl = new RESTOrganizationServiceXMLImpl(organizationService);
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/group/create/")
    public Response createGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupName") String groupName, @QueryParam(value="label") String label, @QueryParam(value="description") String description, @QueryParam(value="parentId") String parentId) {
        Response response = this.xmlImpl.createGroup(baseURI, groupName, label, description, parentId);
        return response;
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/membership/create/")
    public Response createMembership(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="groupId") String groupId, @QueryParam(value="type") String type) {
        Response response = this.xmlImpl.createMembership(baseURI, username, groupId, type);
        return response;
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/user/create/")
    public Response createUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email) {
        Response response = this.xmlImpl.createUser(baseURI, username, password, firstname, lastname, email);
        return response;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/delete/")
    public Response deleteGroup(@QueryParam(value="groupId") String groupId) {
        Response response = this.xmlImpl.deleteGroup(groupId);
        return response;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/delete/{membershipId}/")
    public Response deleteMembership(@URIParam(value="membershipId") String membershipId) {
        Response response = this.xmlImpl.deleteMembership(membershipId);
        return response;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/delete/{username}/")
    public Response deleteUser(@URIParam(value="username") String username) {
        Response response = this.xmlImpl.deleteUser(username);
        return response;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/delete-user/")
    public Response deleteUserFromGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId, @QueryParam(value="username") String username) {
        Response response = this.xmlImpl.deleteUserFromGroup(baseURI, groupId, username);
        return response;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/info/{membershipId}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response findMembership(@ContextParam(value="baseURI") String baseURI, @URIParam(value="membershipId") String membershipId) {
        Response response = this.xmlImpl.findMembership(baseURI, membershipId);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, MEMBERSHIP_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/view-all/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response findMemberships(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId, @QueryParam(value="username") String username, @QueryParam(value="type") String type) {
        Response response = this.xmlImpl.findMemberships(baseURI, groupId, username, type);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, MEMBERSHIP_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/find-all/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response findUsers(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate) {
        Response response = this.xmlImpl.findUsers(baseURI, username, firstname, lastname, email, fromLoginDate, toLoginDate);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USERS_LIST_SEARCH_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/user/find-from-to/{from}/{to}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response findUsersRange(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate, @URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount) {
        Response response = this.xmlImpl.findUsersRange(baseURI, username, firstname, lastname, email, fromLoginDate, toLoginDate, offset, amount);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USERS_LIST_SEARCH_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/filter/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response getAllGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="filter") String filter) {
        Response response = this.xmlImpl.getAllGroup(baseURI, filter);
        if (response.getStatus() != 200) {
            return response;
        }
        Object entity = response.getEntity();
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        String buff = "";
        try {
            ((SerializableEntity)entity).writeObject((OutputStream)out);
            buff = new String(out.toByteArray());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Response.Builder.ok((Object)buff).mediaType("text/xml").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/info/{groupId}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroup(@ContextParam(value="baseURI") String baseURI, @URIParam(value="groupId") String groupId) {
        Response response = this.xmlImpl.getGroup(baseURI, groupId);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            String schemaName = GROUP_INFO_SCHEMA;
            return this.modifyResponse(response, schemaName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/edit/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response editGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId) {
        Response response = this.xmlImpl.getGroup(baseURI, groupId);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            String schemaName = GROUP_EDIT_SCHEMA;
            return this.modifyResponse(response, schemaName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/view-all/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroups(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="parentId") String parentId) {
        Response response = this.xmlImpl.getGroups(baseURI, parentId);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            String schema_name = parentId == null ? GROUPS_LIST_SCHEMA : GROUPS_LIST_FRAGMENT_SCHEMA;
            return this.modifyResponse(response, schema_name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/count/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroupsCount() {
        Response response = this.xmlImpl.getGroupsCount();
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_FRAGMENT_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/groups-for-user/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroupsOfUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username) {
        Response response = this.xmlImpl.getGroupsOfUser(baseURI, username);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/view-from-to/{from}/{to}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroupsRange(@ContextParam(value="baseURI") String baseURI, @URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount, @QueryParam(value="parentId") String parentId) {
        Response response = this.xmlImpl.getGroupsRange(baseURI, offset, amount, parentId);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_FRAGMENT_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/get-types/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getMembershipTypes() {
        Response response = this.xmlImpl.getMembershipTypes();
        return response;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/info/{username}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getUser(@URIParam(value="username") String username) {
        Response response = this.xmlImpl.getUser(username);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USER_INFO_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/users/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getUsers(@ContextParam(value="baseURI") String baseURI) {
        Response response = this.xmlImpl.getUsers(baseURI);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USERS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/count/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getUsersCount() {
        Response response = this.xmlImpl.getUsersCount();
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/view-range/{from}/{number}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getUsersRange(@ContextParam(value="baseURI") String baseURI, @URIParam(value="from") Integer offset, @URIParam(value="number") Integer amount) {
        Response response = this.xmlImpl.getUsersRange(baseURI, offset, amount);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USERS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/group/update/")
    public Response updateGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId, @QueryParam(value="name") String name, @QueryParam(value="label") String label, @QueryParam(value="description") String description) {
        Response response = this.xmlImpl.updateGroup(baseURI, groupId, name, label, description);
        return response;
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/user/update/")
    public Response updateUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email) {
        Response response = this.xmlImpl.updateUser(baseURI, username, password, firstname, lastname, email);
        return response;
    }

    private Response modifyResponse(final Response response, String xsltSchemaName) throws IOException {
        response.setTransformer((OutputEntityTransformer)new SerializableTransformer());
        final PipedOutputStream po = new PipedOutputStream();
        PipedInputStream pi = new PipedInputStream(po);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    response.writeEntity((OutputStream)po);
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Thrown exception : " + e));
                }
                finally {
                    try {
                        po.flush();
                        po.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
        StreamSource s = new StreamSource(pi);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("xslt.template", xsltSchemaName);
        return Response.Builder.ok((Object)s, (String)"text/html").setTransformerParameters(p).build();
    }
}

