/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.json;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.rest.RESTOrganizationServiceAbstractImpl;
import org.exoplatform.services.organization.rest.json.CountBean;
import org.exoplatform.services.organization.rest.json.GroupListBean;
import org.exoplatform.services.organization.rest.json.GroupMembersBean;
import org.exoplatform.services.organization.rest.json.MembershipListBean;
import org.exoplatform.services.organization.rest.json.MembershipTypesListBean;
import org.exoplatform.services.organization.rest.json.UserBean;
import org.exoplatform.services.organization.rest.json.UserListBean;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@URITemplate(value="/organization/json/")
public class RESTOrganizationServiceJSONImpl
extends RESTOrganizationServiceAbstractImpl
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    private static final String ASCENDING = "ascending";
    private static final String DESCENDING = "descending";
    private static final String USERNAME = "username";
    private static final String FIRSTNAME = "firstname";
    private static final String LASTNAME = "lastname";

    public RESTOrganizationServiceJSONImpl(OrganizationService organizationService) {
        super(organizationService);
    }

    @Override
    @HTTPMethod(value="POST")
    @URITemplate(value="/group/create/")
    public Response createGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupName") String groupName, @QueryParam(value="label") String label, @QueryParam(value="description") String description, @QueryParam(value="parentId") String parentId) {
        Response response = super.createGroup(baseURI, groupName, label, description, parentId);
        if (response != null) {
            return response;
        }
        String id = ((Group)response.getEntity()).getId();
        return Response.Builder.created((String)(baseURI + "/organization/json/group/info" + id)).build();
    }

    @Override
    @HTTPMethod(value="POST")
    @URITemplate(value="/membership/create")
    public Response createMembership(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="groupId") String groupId, @QueryParam(value="type") String type) {
        Response response = super.createMembership(baseURI, username, groupId, type);
        if (response != null) {
            return response;
        }
        String id = ((Membership)response.getEntity()).getId();
        return Response.Builder.created((String)(baseURI + "/organization/json/membership/info/" + id)).build();
    }

    @Override
    @HTTPMethod(value="POST")
    @URITemplate(value="/user/create/")
    public Response createUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email) {
        Response response = super.createUser(baseURI, username, password, firstname, lastname, email);
        if (response != null) {
            return response;
        }
        return Response.Builder.created((String)(baseURI + "/organization/json/user/" + username)).build();
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/group/delete/")
    public Response deleteGroup(@QueryParam(value="groupId") String groupId) {
        Response response = super.deleteGroup(groupId);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/delete/{membershipId}/")
    public Response deleteMembership(@URIParam(value="membershipId") String membershipId) {
        Response response = super.deleteMembership(membershipId);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/user/delete/{username}/")
    public Response deleteUser(@URIParam(value="username") String username) {
        Response response = super.deleteUser(username);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/group/delete-user/")
    public Response deleteUserFromGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId, @QueryParam(value="username") String username) {
        Response response = super.deleteUserFromGroup(baseURI, groupId, username);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/info/{membershipId}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findMembership(@ContextParam(value="baseURI") String baseURI, @URIParam(value="membershipId") String membershipId) {
        Membership membership = null;
        try {
            membership = this.membershipHandler.findMembership(membershipId);
            if (membership != null) {
                return Response.Builder.ok((Object)membership, (String)JSON_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).errorMessage("Membership with id: '" + membershipId + "' not found!").build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/view-all/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findMemberships(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId, @QueryParam(value="username") String username, @QueryParam(value="type") String type) {
        try {
            MembershipListBean membership_list;
            Collection memberships = null;
            if (groupId != null && username != null && type != null) {
                Membership membership = this.membershipHandler.findMembershipByUserGroupAndType(username, groupId = groupId.startsWith("/") ? groupId : "/" + groupId, type);
                if (membership != null) {
                    return Response.Builder.ok((Object)membership, (String)JSON_CONTENT_TYPE).build();
                }
                return Response.Builder.withStatus((int)404).errorMessage("Membership for groupId: '" + groupId + "', username: '" + username + "', membership type: '" + type + "' not found!").build();
            }
            if (groupId != null && username != null) {
                groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
                memberships = this.membershipHandler.findMembershipsByUserAndGroup(username, groupId);
            } else if (groupId != null) {
                Group group = this.groupHandler.findGroupById(groupId = groupId.startsWith("/") ? groupId : "/" + groupId);
                if (group == null) {
                    return Response.Builder.withStatus((int)404).errorMessage("Group '" + groupId + "' not found!").build();
                }
                memberships = this.membershipHandler.findMembershipsByGroup(group);
            } else if (username != null) {
                memberships = this.membershipHandler.findMembershipsByUser(username);
            } else {
                return Response.Builder.withStatus((int)500).errorMessage("Username, groupId or membership type should be specified!").build();
            }
            if (username != null && this.userHandler.findUserByName(username) != null) {
                membership_list = new MembershipListBean(username, memberships);
                return Response.Builder.ok((Object)membership_list, (String)JSON_CONTENT_TYPE).build();
            }
            membership_list = new MembershipListBean(null, memberships);
            return Response.Builder.ok((Object)membership_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/user/find-all/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findUsers(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate) {
        try {
            Query query = new Query();
            query.setUserName(username);
            query.setFirstName(firstname);
            query.setLastName(lastname);
            query.setEmail(email);
            if (fromLoginDate != null) {
                try {
                    query.setFromLoginDate(DateFormat.getDateTimeInstance().parse(fromLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            if (toLoginDate != null) {
                try {
                    query.setToLoginDate(DateFormat.getDateTimeInstance().parse(toLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            List list = this.userHandler.findUsers(query).getAll();
            ArrayList<UserBean> listBean = new ArrayList<UserBean>();
            for (User user : list) {
                if (user == null) continue;
                listBean.add(new UserBean(user));
            }
            UserListBean user_list = new UserListBean(listBean);
            return Response.Builder.ok((Object)user_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="POST")
    @URITemplate(value="/user/view-from-to/{from}/{to}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findUsersRange(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate, @URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount) {
        try {
            Query query = new Query();
            query.setUserName(username);
            query.setFirstName(firstname);
            query.setLastName(lastname);
            query.setEmail(email);
            if (fromLoginDate != null) {
                try {
                    query.setFromLoginDate(DateFormat.getDateTimeInstance().parse(fromLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            if (toLoginDate != null) {
                try {
                    query.setToLoginDate(DateFormat.getDateTimeInstance().parse(toLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            List list = this.userHandler.findUsers(query).getAll();
            Integer amount_ = amount;
            if (amount > list.size()) {
                amount_ = list.size();
            }
            List listSub = list.subList(offset, amount_);
            ArrayList<UserBean> listBean = new ArrayList<UserBean>();
            for (User user : listSub) {
                if (user == null) continue;
                listBean.add(new UserBean(user));
            }
            UserListBean user_list = new UserListBean(listBean);
            return Response.Builder.ok((Object)user_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/find-user-in-range/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findUsersRange2(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="question") String question, @QueryParam(value="from") Integer from, @QueryParam(value="to") Integer to, @QueryParam(value="sort-order") String sortOrder, @QueryParam(value="sort-field") String sortField) {
        try {
            List temp = new ArrayList();
            Comparator<User> comparator = this.getComparator(sortField, sortOrder);
            if (comparator == null) {
                LOGGER.error((Object)("You set wrong parameters fo sorting! sort-order = [ascending, descending], sort-field = [username, lastname, firstname]. You set sort-field = " + sortField + " sort-order = " + sortOrder));
                return Response.Builder.withStatus((int)400).errorMessage("You set wrong parameters fo sorting! sort-order = [ascending, descending], sort-field = [username, lastname, firstname]. You set sort-field = " + sortField + " sort-order = " + sortOrder).build();
            }
            TreeSet<User> users = new TreeSet<User>(comparator);
            Query query = new Query();
            query.setUserName(question);
            temp = this.userHandler.findUsers(query).getAll();
            for (User user : temp) {
                if (users.contains(user)) continue;
                users.add(user);
            }
            query = new Query();
            query.setFirstName(question);
            temp = this.userHandler.findUsers(query).getAll();
            for (User user : temp) {
                if (users.contains(user)) continue;
                users.add(user);
            }
            query = new Query();
            query.setLastName(question);
            temp = this.userHandler.findUsers(query).getAll();
            for (User user : temp) {
                if (users.contains(user)) continue;
                users.add(user);
            }
            if (to > users.size()) {
                to = users.size();
            }
            ArrayList<User> uList = new ArrayList<User>();
            for (User user : users) {
                uList.add(user);
            }
            List listSub = uList.subList(from, to);
            ArrayList<UserBean> listBean = new ArrayList<UserBean>();
            for (User user : listSub) {
                if (user == null) continue;
                listBean.add(new UserBean(user));
            }
            UserListBean user_list = new UserListBean(listBean);
            user_list.setTotalUser(users.size());
            return Response.Builder.ok((Object)user_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/group/filter/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getAllGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="filter") String filter) {
        try {
            Collection groups = this.groupHandler.getAllGroups();
            if (filter != null && filter.length() > 0) {
                ArrayList temp = new ArrayList(groups);
                for (Group g : temp) {
                    if (g.getId().contains(filter)) continue;
                    groups.remove(g);
                }
            }
            GroupListBean group_list = new GroupListBean(groups);
            return Response.Builder.ok((Object)group_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/group/info/{groupId}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroup(@ContextParam(value="baseURI") String baseURI, @URIParam(value="groupId") String groupId) {
        try {
            groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                return Response.Builder.withStatus((int)404).errorMessage("Group '" + groupId + "' not found.").build();
            }
            List members = this.userHandler.findUsersByGroup(groupId).getAll();
            return Response.Builder.ok((Object)new GroupMembersBean(group, members), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/group/view-all/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroups(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="parentId") String parentId) {
        try {
            Collection groups = null;
            if (parentId != null && parentId.length() > 0) {
                Group parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId);
                if (parent == null) {
                    return Response.Builder.withStatus((int)404).errorMessage("Parent '" + parentId + "' not found.").build();
                }
                groups = this.groupHandler.findGroups(parent);
            } else {
                groups = this.groupHandler.findGroups(null);
            }
            GroupListBean group_list = new GroupListBean(groups);
            return Response.Builder.ok((Object)group_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/group/count/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroupsCount() {
        try {
            int number = this.groupHandler.getAllGroups().size();
            return Response.Builder.ok((Object)new CountBean(number), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/group/groups-for-user/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroupsOfUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username) {
        try {
            if (this.userHandler.findUserByName(username) == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User '" + username + "' not found.").build();
            }
            Collection groups = this.groupHandler.findGroupsOfUser(username);
            GroupListBean group_list = new GroupListBean(groups);
            return Response.Builder.ok((Object)group_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/group/view-from-to/{from}/{to}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroupsRange(@ContextParam(value="baseURI") String baseURI, @URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount, @QueryParam(value="parentId") String parentId) {
        try {
            Collection groups = null;
            if (parentId != null && parentId.length() > 0) {
                Group parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId);
                if (parent == null) {
                    return Response.Builder.withStatus((int)404).errorMessage("Parent '" + parentId + "' not found.").build();
                }
                groups = this.groupHandler.findGroups(parent);
            } else {
                groups = this.groupHandler.findGroups(null);
            }
            Integer amount_ = amount;
            if (amount > groups.size()) {
                amount_ = groups.size();
            }
            GroupListBean group_list = new GroupListBean(new ArrayList(groups).subList(offset, amount_));
            return Response.Builder.ok((Object)group_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/get-types/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getMembershipTypes() {
        try {
            Collection membershipTypes = this.membershipTypeHandler.findMembershipTypes();
            MembershipTypesListBean membership_types_list = new MembershipTypesListBean(membershipTypes);
            return Response.Builder.ok((Object)membership_types_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/user/info/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUser(@URIParam(value="username") String username) {
        try {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User '" + username + "' not found.").build();
            }
            return Response.Builder.ok((Object)user).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/users/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUsers(@ContextParam(value="baseURI") String baseURI) {
        try {
            List list = this.userHandler.findUsers(new Query()).getAll();
            ArrayList<UserBean> listBean = new ArrayList<UserBean>();
            for (User user : list) {
                if (user == null) continue;
                listBean.add(new UserBean(user));
            }
            UserListBean user_list = new UserListBean(listBean);
            return Response.Builder.ok((Object)user_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/user/count/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUsersCount() {
        try {
            int number = this.userHandler.findUsers(new Query()).getAll().size();
            return Response.Builder.ok((Object)new CountBean(number), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/user/view-range/{from}/{number}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUsersRange(@ContextParam(value="baseURI") String baseURI, @URIParam(value="from") Integer offset, @URIParam(value="number") Integer amount) {
        try {
            List list = this.userHandler.findUsers(new Query()).getAll();
            int prevFrom = -1;
            if (offset > 0) {
                prevFrom = offset - amount > 0 ? offset - amount : 0;
            }
            int nextFrom = offset + amount < list.size() ? offset + amount : -1;
            int to = offset + amount < list.size() ? offset + amount : list.size();
            List listSub = list.subList(offset, to);
            ArrayList<UserBean> listBean = new ArrayList<UserBean>();
            for (User user : listSub) {
                if (user == null) continue;
                listBean.add(new UserBean(user));
            }
            UserListBean user_list = new UserListBean(listBean);
            return Response.Builder.ok((Object)user_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="POST")
    @URITemplate(value="/group/update/")
    public Response updateGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId, @QueryParam(value="name") String name, @QueryParam(value="label") String label, @QueryParam(value="description") String description) {
        Response response = super.updateGroup(baseURI, groupId, name, label, description);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @Override
    @HTTPMethod(value="POST")
    @URITemplate(value="/user/update/")
    public Response updateUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email) {
        Response response = super.updateUser(baseURI, username, password, firstname, lastname, email);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    private Comparator<User> getComparator(String sortField, String sortOrder) {
        if (sortOrder == null || sortOrder.length() == 0) {
            sortOrder = ASCENDING;
        }
        if (sortField == null || sortField.length() == 0) {
            sortField = USERNAME;
        }
        if (sortOrder.equalsIgnoreCase(ASCENDING)) {
            if (sortField.equalsIgnoreCase(FIRSTNAME)) {
                return new FirstNameComporatorAsc();
            }
            if (sortField.equalsIgnoreCase(LASTNAME)) {
                return new LastNameComporatorAsc();
            }
            if (sortField.equalsIgnoreCase(USERNAME)) {
                return new UserNameComporatorAsc();
            }
        } else if (sortOrder.equalsIgnoreCase(DESCENDING)) {
            if (sortField.equalsIgnoreCase(FIRSTNAME)) {
                return new FirstNameComporatorDesc();
            }
            if (sortField.equalsIgnoreCase(LASTNAME)) {
                return new LastNameComporatorDesc();
            }
            if (sortField.equalsIgnoreCase(USERNAME)) {
                return new UserNameComporatorDesc();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastNameComporatorDesc
    implements Comparator<User> {
        private LastNameComporatorDesc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getLastName() == null) {
                return -1;
            }
            if (u2.getLastName() == null) {
                return 1;
            }
            return -u1.getLastName().compareTo(u2.getLastName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastNameComporatorAsc
    implements Comparator<User> {
        private LastNameComporatorAsc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getLastName() == null) {
                return 1;
            }
            if (u2.getLastName() == null) {
                return -1;
            }
            return u1.getLastName().compareTo(u2.getLastName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirstNameComporatorDesc
    implements Comparator<User> {
        private FirstNameComporatorDesc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getFirstName() == null) {
                return -1;
            }
            if (u2.getFirstName() == null) {
                return 1;
            }
            return -u1.getFirstName().compareTo(u2.getFirstName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirstNameComporatorAsc
    implements Comparator<User> {
        private FirstNameComporatorAsc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getFirstName() == null) {
                return 1;
            }
            if (u2.getFirstName() == null) {
                return -1;
            }
            return u1.getFirstName().compareTo(u2.getFirstName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserNameComporatorDesc
    implements Comparator<User> {
        private UserNameComporatorDesc() {
        }

        @Override
        public int compare(User u1, User u2) {
            return -u1.getUserName().compareTo(u2.getUserName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserNameComporatorAsc
    implements Comparator<User> {
        private UserNameComporatorAsc() {
        }

        @Override
        public int compare(User u1, User u2) {
            return u1.getUserName().compareTo(u2.getUserName());
        }
    }
}

