/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin.exobuild;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.exoplatform.maven.plugin.exec.Classpath;
import org.exoplatform.maven.plugin.exec.StreamLog;
import org.exoplatform.maven.plugin.exec.UrlUtils;
import org.exoplatform.maven.plugin.exobuild.AbstractFromDependenciesMojo;
import org.exoplatform.maven.plugin.exobuild.utils.DependencyStatusSets;
import org.exoplatform.maven.plugin.exobuild.utils.DependencyUtil;
import org.exoplatform.maven.plugin.exobuild.utils.filters.DestFileFilter;
import org.exoplatform.maven.plugin.exobuild.utils.markers.DefaultFileMarkerHandler;

public class ExobuildMojo
extends AbstractFromDependenciesMojo {
    protected File exoWorkingDir;
    protected File exoDependenciesDir;
    protected String exobuildTomcatVersion;
    protected String exobuildJBossVersion;
    protected String exoBaseDir;
    private String product;
    private String deploy;
    private String release;
    private String database;
    private String dbsetup;
    private String enable_workflow;
    private String lcf;
    private String mavenHome;
    protected File outputDirectoryPackager;
    protected File outputDirectoryPackagerConf;
    protected ArtifactInstaller installer;
    protected ArtifactRepositoryFactory repositoryFactory;
    private String executable;
    private File outputFile;
    private List arguments;
    private File basedir;
    private Map environmentVariables = new HashMap();
    private MavenSession session;
    private List successCodes;
    private boolean longClasspath;
    public static final String CLASSPATH_TOKEN = "%classpath";
    private File sourceRoot;
    private File testSourceRoot;
    private String commandlineArgs;
    protected String classpathScope;
    private static final char PARAMETER_DELIMITER = ' ';
    private static final char STRING_WRAPPER = '\"';
    private static final char ESCAPE_CHAR = '\\';

    public void execute() throws MojoExecutionException {
        System.out.println("Welcome to packager !!");
        System.out.println("* Product=" + this.product);
        System.out.println("* Deploy=" + this.deploy);
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        Set artifacts = dss.getResolvedDependencies();
        for (Artifact artifact : artifacts) {
            if (artifact.getType().equals("js")) {
                String destFileName = DependencyUtil.getFormattedFileName(artifact, true);
                File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.outputDirectoryPackagerConf, artifact);
                File destFile = new File(destDir, destFileName);
                this.copyFile(artifact.getFile(), destFile);
            }
            if (!artifact.getArtifactId().contains("package") || !artifact.getType().equals("zip")) continue;
            File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.outputDirectoryPackager, artifact);
            this.unpack(artifact.getFile(), destDir, null, null);
            DefaultFileMarkerHandler handler = new DefaultFileMarkerHandler(artifact, this.markersDirectory);
            handler.setMarker();
        }
        String[] deployList = this.deploy.split(",");
        for (int i = 0; i < deployList.length; ++i) {
            String deployTarget = deployList[i];
            this.executeExobuild(deployTarget);
        }
    }

    public void copyPoms(File destDir, Set artifacts, boolean removeVersion) throws MojoExecutionException {
        for (Artifact artifact : artifacts) {
            File pomDestFile;
            Artifact pomArtifact = this.getResolvedPomArtifact(artifact);
            if (pomArtifact.getFile() == null || !pomArtifact.getFile().exists() || (pomDestFile = new File(destDir, DependencyUtil.getFormattedFileName(pomArtifact, removeVersion))).exists()) continue;
            this.copyFile(pomArtifact.getFile(), pomDestFile);
        }
    }

    protected Artifact getResolvedPomArtifact(Artifact artifact) {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        try {
            this.resolver.resolve(pomArtifact, this.remoteRepos, this.local);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
        return pomArtifact;
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new DestFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, this.useSubDirectoryPerArtifact, this.useSubDirectoryPerType, this.useRepositoryLayout, this.stripVersion, this.outputDirectory);
    }

    public void executeExobuild(String deployTarget) throws MojoExecutionException {
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is null. Should not be possible.");
        }
        if (this.exoWorkingDir == null) {
            throw new IllegalStateException("exo.working.dir is null. Please define it as property or exoWorkingDir in maven-exobuild-plugin configuration.");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-Dexo.package.home=" + this.basedir + "/target/packager");
        arguments.add("-Dexo.current.dir=" + this.basedir);
        arguments.add("-Dexo.base.dir=" + this.exoBaseDir);
        arguments.add("-Dexo.conf.dir=" + this.basedir + "/target/packager-conf");
        arguments.add("-Dexo.working.dir=" + this.exoWorkingDir);
        arguments.add("-Dexo.dep.dir=" + this.exoDependenciesDir);
        arguments.add("-Dexo.m2.repos=file:" + this.local.getBasedir());
        if (deployTarget.startsWith("tomcat")) {
            arguments.add("-Dclean.server=" + this.exobuildTomcatVersion);
        }
        if (deployTarget.startsWith("jboss")) {
            arguments.add("-Dclean.server=" + this.exobuildJBossVersion);
        }
        arguments.add("-Dexo.m2.home=" + this.mavenHome);
        arguments.add("-DrepoUrl=xxx");
        arguments.add("-Xshare:auto");
        arguments.add("-Xms128m");
        arguments.add("-Xmx512m");
        arguments.add("-classpath");
        arguments.add(this.basedir + "/target/packager/lib/js.jar");
        arguments.add("org.mozilla.javascript.tools.shell.Main");
        arguments.add(this.basedir + "/target/packager/javascript/eXo/eXo.js");
        arguments.add("exobuild");
        arguments.add("--product=" + this.product);
        if (this.release != null) {
            arguments.add("--release=" + deployTarget);
        }
        if (this.release == null && deployTarget != null) {
            arguments.add("--deploy=" + deployTarget);
        }
        if (this.database != null) {
            arguments.add("--database=" + this.database);
        }
        if (this.dbsetup != null) {
            arguments.add("--dbsetup=" + this.dbsetup);
        }
        if (this.enable_workflow != null) {
            arguments.add("--enable-workflow=" + this.enable_workflow);
        }
        if (this.lcf != null) {
            arguments.add("--lcf");
        }
        String[] args = arguments.toArray(new String[arguments.size()]);
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.getExecutablePath());
        commandLine.addArguments(args);
        File workingDirectory = this.basedir;
        if (!workingDirectory.exists()) {
            this.getLog().debug((CharSequence)("Making working directory '" + workingDirectory.getAbsolutePath() + "'."));
            if (!workingDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not make working directory: '" + workingDirectory.getAbsolutePath() + "'");
            }
        }
        commandLine.setWorkingDirectory(workingDirectory.getAbsolutePath());
        if (this.environmentVariables != null) {
            for (String key : this.environmentVariables.keySet()) {
                String value = (String)this.environmentVariables.get(key);
                commandLine.addEnvironment(key, value);
            }
        }
        final Log outputLog = this.getExecOutputLog();
        StreamConsumer stdout = new StreamConsumer(){

            public void consumeLine(String line) {
                outputLog.info((CharSequence)line);
            }
        };
        StreamConsumer stderr = new StreamConsumer(){

            public void consumeLine(String line) {
                outputLog.info((CharSequence)line);
            }
        };
        try {
            this.getLog().debug((CharSequence)("Executing command line: " + commandLine));
            int resultCode = this.executeCommandLine(commandLine, stdout, stderr);
            if (this.isResultCodeAFailure(resultCode)) {
                throw new MojoExecutionException("Result of " + commandLine + " execution is: '" + resultCode + "'.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
        }
        this.registerSourceRoots();
    }

    boolean isResultCodeAFailure(int result) {
        if (this.successCodes == null || this.successCodes.size() == 0) {
            return result != 0;
        }
        Iterator it = this.successCodes.iterator();
        while (it.hasNext()) {
            int code = Integer.parseInt((String)it.next());
            if (code != result) continue;
            return false;
        }
        return true;
    }

    private Log getExecOutputLog() {
        Log log = this.getLog();
        if (this.outputFile != null) {
            try {
                if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                    this.getLog().warn((CharSequence)("Could not create non existing parent directories for log file: " + this.outputFile));
                }
                PrintStream stream = new PrintStream(new FileOutputStream(this.outputFile));
                log = new StreamLog(stream);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Could not open " + this.outputFile + ". Using default log"), (Throwable)e);
            }
        }
        return log;
    }

    private String computeClasspathString(Classpath specifiedClasspath) {
        List resultList = this.computeClasspath(specifiedClasspath);
        StringBuffer theClasspath = new StringBuffer();
        for (String str : resultList) {
            ExobuildMojo.addToClasspath(theClasspath, str);
        }
        return theClasspath.toString();
    }

    private List computeClasspath(Classpath specifiedClasspath) {
        List artifacts = new ArrayList();
        ArrayList theClasspathFiles = new ArrayList();
        ArrayList<String> resultList = new ArrayList<String>();
        this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
        if (specifiedClasspath != null && specifiedClasspath.getDependencies() != null) {
            artifacts = this.filterArtifacts(artifacts, specifiedClasspath.getDependencies());
        }
        for (File f : theClasspathFiles) {
            resultList.add(f.getAbsolutePath());
        }
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("dealing with " + artifact));
            resultList.add(artifact.getFile().getAbsolutePath());
        }
        return resultList;
    }

    private static void addToClasspath(StringBuffer theClasspath, String toAdd) {
        if (theClasspath.length() > 0) {
            theClasspath.append(File.pathSeparator);
        }
        theClasspath.append(toAdd);
    }

    private List filterArtifacts(List artifacts, Collection dependencies) {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new IncludesArtifactFilter(new ArrayList(dependencies)));
        ArrayList<Artifact> filteredArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            this.getLog().debug((CharSequence)("filtering in " + artifact));
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    String getExecutablePath() {
        File execFile = new File(this.executable);
        if (execFile.exists()) {
            this.getLog().debug((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.executable));
            return execFile.getAbsolutePath();
        }
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in exec-maven-plugin: " + tc));
            this.executable = tc.findTool(this.executable);
        }
        return this.executable;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    protected int executeCommandLine(Commandline commandLine, StreamConsumer stream1, StreamConsumer stream2) throws CommandLineException {
        return CommandLineUtils.executeCommandLine((Commandline)commandLine, (StreamConsumer)stream1, (StreamConsumer)stream2);
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    String getExecutable() {
        return this.executable;
    }

    void setArguments(List arguments) {
        this.arguments = arguments;
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    protected String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    public void setSuccessCodes(List list) {
        this.successCodes = list;
    }

    public List getSuccessCodes() {
        return this.successCodes;
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }

    private File createJar(List classPath, String mainClass) throws IOException {
        File file = File.createTempFile("maven-exec", ".jar");
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        JarOutputStream jos = new JarOutputStream(fos);
        jos.setLevel(0);
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        jos.putNextEntry(je);
        Manifest man = new Manifest();
        String cp = "";
        for (String el : classPath) {
            cp = cp + UrlUtils.getURL(new File(el)).toExternalForm() + " ";
        }
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue("Class-Path", cp.trim());
        man.getMainAttributes().putValue("Main-Class", mainClass);
        man.write(jos);
        jos.close();
        return file;
    }

    protected void collectProjectArtifactsAndClasspath(List artifacts, List theClasspathFiles) {
        if ("compile".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getCompileArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("test".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getTestArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getTestOutputDirectory()));
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("runtime".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getRuntimeArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("system".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getSystemArtifacts());
        } else {
            throw new IllegalStateException("Invalid classpath scope: " + this.classpathScope);
        }
        this.getLog().debug((CharSequence)("Collected project artifacts " + artifacts));
        this.getLog().debug((CharSequence)("Collected project classpath " + theClasspathFiles));
    }

    protected String[] parseCommandlineArgs() throws MojoExecutionException {
        if (this.commandlineArgs == null) {
            return null;
        }
        boolean inString = false;
        String arguments = this.commandlineArgs.trim();
        LinkedList<String> argumentList = new LinkedList<String>();
        StringBuffer arg = new StringBuffer();
        for (int chr = 0; chr < arguments.length(); ++chr) {
            char curChar = arguments.charAt(chr);
            if (curChar == '\\') {
                if (arguments.length() == chr + 1) {
                    this.getLog().warn((CharSequence)"\\ was the last character in your command line arguments. Verify your parameters.");
                    continue;
                }
                if (!inString || arguments.charAt(chr + 1) == '\"') {
                    ++chr;
                }
                arg.append(arguments.charAt(chr));
                continue;
            }
            if (curChar == ' ' && !inString) {
                argumentList.add(arg.toString());
                arg.delete(0, arg.length());
                continue;
            }
            if (curChar == '\"') {
                inString = !inString;
                continue;
            }
            arg.append(curChar);
        }
        if (inString) {
            throw new MojoExecutionException("args contains not properly formatted string");
        }
        argumentList.add(arg.toString());
        ListIterator it = argumentList.listIterator();
        String[] result = new String[argumentList.size()];
        int index = 0;
        while (it.hasNext()) {
            result[index] = (String)it.next();
            ++index;
        }
        this.getLog().debug((CharSequence)"Args:");
        it = argumentList.listIterator();
        while (it.hasNext()) {
            this.getLog().debug((CharSequence)(" <" + (String)it.next() + ">"));
        }
        this.getLog().debug((CharSequence)(" parsed from <" + this.commandlineArgs + ">"));
        return result;
    }

    protected boolean hasCommandlineArgs() {
        return this.commandlineArgs != null;
    }

    protected void registerSourceRoots() {
        if (this.sourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile source root " + this.sourceRoot));
            this.project.addCompileSourceRoot(this.sourceRoot.toString());
        }
        if (this.testSourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile test source root " + this.testSourceRoot));
            this.project.addTestCompileSourceRoot(this.testSourceRoot.toString());
        }
    }
}

