/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin.exobuild.utils.resolvers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.exoplatform.maven.plugin.exobuild.utils.resolvers.ArtifactsResolver;

public class DefaultArtifactsResolver
implements ArtifactsResolver {
    ArtifactResolver resolver;
    ArtifactRepository local;
    List remoteRepositories;
    boolean stopOnFailure;

    public DefaultArtifactsResolver(ArtifactResolver theResolver, ArtifactRepository theLocal, List theRemoteRepositories, boolean theStopOnFailure) {
        this.resolver = theResolver;
        this.local = theLocal;
        this.remoteRepositories = theRemoteRepositories;
        this.stopOnFailure = theStopOnFailure;
    }

    public Set resolve(Set artifacts, Log log) throws MojoExecutionException {
        HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            try {
                this.resolver.resolve(artifact, this.remoteRepositories, this.local);
                resolvedArtifacts.add(artifact);
            }
            catch (ArtifactResolutionException ex) {
                log.debug((CharSequence)("error resolving: " + artifact.getId()));
                log.debug((Throwable)ex);
                if (!this.stopOnFailure) continue;
                throw new MojoExecutionException("error resolving: " + artifact.getId(), (Exception)((Object)ex));
            }
            catch (ArtifactNotFoundException ex) {
                log.debug((CharSequence)("not found in any repository: " + artifact.getId()));
                if (!this.stopOnFailure) continue;
                throw new MojoExecutionException("not found in any repository: " + artifact.getId(), (Exception)((Object)ex));
            }
        }
        return resolvedArtifacts;
    }
}

