/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.service.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.stack.cxf.deployment.SecurityActions;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;

public class EndpointImpl
extends org.apache.cxf.jaxws22.EndpointImpl {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointImpl.class);
    private WSDLFilePublisher wsdlPublisher;
    private CommonConfig config;
    private static Map<String, String> bindingIDs = new HashMap<String, String>();

    public EndpointImpl(Object implementor) {
        super(implementor);
    }

    public EndpointImpl(Bus bus, Object implementor) {
        super(bus, implementor);
    }

    protected void doPublish(String addr) {
        super.getServerFactory().setBlockPostConstruct(true);
        super.doPublish(addr);
        this.configureObject((Object)this);
        this.setupConfigHandlers();
        this.publishContractToFilesystem();
    }

    public void setEndpointConfig(CommonConfig config) {
        if (this.config == null) {
            this.config = config;
            Map epConfProps = config.getProperties();
            if (!epConfProps.isEmpty()) {
                if (this.getProperties() == null) {
                    this.setProperties(new HashMap(epConfProps));
                } else {
                    this.getProperties().putAll(epConfProps);
                }
            }
        }
    }

    protected List<Handler> convertToHandlers(List<UnifiedHandlerChainMetaData> handlerChains) {
        LinkedList<Handler> handlers = new LinkedList<Handler>();
        if (handlerChains != null && !handlerChains.isEmpty()) {
            String protocolBinding = bindingIDs.get(this.getBinding().getBindingID());
            for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
                if (handlerChain.getPortNamePattern() != null || handlerChain.getServiceNamePattern() != null) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"FILTERS_NOT_SUPPORTED", (Object[])new Object[0]));
                }
                if (!EndpointImpl.matchProtocolBinding(protocolBinding, handlerChain.getProtocolBindings())) continue;
                for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers()) {
                    Object h;
                    if (uhmd.getInitParams() != null && !uhmd.getInitParams().isEmpty()) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"INIT_PARAMS_NOT_SUPPORTED", (Object[])new Object[0]));
                    }
                    if ((h = EndpointImpl.newInstance(uhmd.getHandlerClass())) == null) continue;
                    if (h instanceof Handler) {
                        handlers.add((Handler)h);
                        continue;
                    }
                    throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_HANDLER_INSTANCE", (Object[])new Object[]{h}));
                }
            }
        }
        return handlers;
    }

    private static boolean matchProtocolBinding(String currentProtocolBinding, String handlerChainProtocolBindings) {
        if (handlerChainProtocolBindings == null) {
            return true;
        }
        LinkedList<String> protocolBindings = new LinkedList<String>();
        if (handlerChainProtocolBindings != null) {
            StringTokenizer st = new StringTokenizer(handlerChainProtocolBindings, " ", false);
            while (st.hasMoreTokens()) {
                protocolBindings.add(st.nextToken());
            }
        }
        return protocolBindings.contains(currentProtocolBinding);
    }

    private static Object newInstance(String className) {
        try {
            DelegateClassLoader loader = new DelegateClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader(), SecurityActions.getContextClassLoader());
            Class<?> clazz = loader.loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            Logger.getLogger(EndpointImpl.class).warnf((Throwable)e, BundleUtils.getMessage((ResourceBundle)bundle, (String)"CAN_NOT_ADD_HANDLER", (Object[])new Object[]{className}), new Object[0]);
            return null;
        }
    }

    protected void setupConfigHandlers() {
        if (this.config != null) {
            List<Handler> handlers = this.convertToHandlers(this.config.getPreHandlerChains());
            handlers.addAll(this.getBinding().getHandlerChain());
            handlers.addAll(this.convertToHandlers(this.config.getPostHandlerChains()));
            this.getBinding().setHandlerChain(handlers);
        }
    }

    protected void publishContractToFilesystem() {
        if (this.wsdlPublisher != null) {
            Endpoint endpoint = this.getServer().getEndpoint();
            Service service = endpoint.getService();
            try {
                JaxWsImplementorInfo info = new JaxWsImplementorInfo(this.getImplementorClass());
                this.wsdlPublisher.publishWsdlFiles(service.getName(), info.getWsdlLocation(), BusFactory.getThreadDefaultBus((boolean)false), service.getServiceInfos());
            }
            catch (IOException ioe) {
                throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"PUBLISHING_WSDL_ERROR", (Object[])new Object[]{service.getName()}), ioe);
            }
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_PUBLISH_CONTRACT", (Object[])new Object[0]));
        }
    }

    private void configureObject(Object instance) {
        Configurer configurer = (Configurer)this.getBus().getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(instance);
        }
    }

    public String getBeanName() {
        QName endpointName = this.getEndpointName();
        if (endpointName == null) {
            JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getImplementorClass());
            endpointName = implInfo.getEndpointName();
        }
        return endpointName.toString() + ".jaxws-endpoint";
    }

    public WSDLFilePublisher getWsdlPublisher() {
        return this.wsdlPublisher;
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }

    static {
        bindingIDs.put("http://schemas.xmlsoap.org/wsdl/soap/http", "##SOAP11_HTTP");
        bindingIDs.put("http://www.w3.org/2003/05/soap/bindings/HTTP/", "##SOAP12_HTTP");
        bindingIDs.put("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true", "##SOAP11_HTTP_MTOM");
        bindingIDs.put("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true", "##SOAP12_HTTP_MTOM");
        bindingIDs.put("http://www.w3.org/2004/08/wsdl/http", "##XML_HTTP");
    }
}

