/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentType;
import org.jboss.wsf.stack.cxf.client.util.SpringUtils;
import org.jboss.wsf.stack.cxf.metadata.MetadataBuilder;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;

public class DescriptorDeploymentAspect
extends AbstractDeploymentAspect {
    private static final boolean PREFER_SPRING_DESCRIPTOR_GENERATION = Boolean.getBoolean("org.jboss.ws.cxf.prefer_spring_descriptor_generation");
    private static final ResourceBundle bundle = BundleUtils.getBundle(DescriptorDeploymentAspect.class);
    private static final Logger log = Logger.getLogger(DescriptorDeploymentAspect.class);

    public void start(Deployment dep) {
        URL cxfURL = null;
        if (SpringUtils.isSpringAvailable((ClassLoader[])new ClassLoader[0]) && (cxfURL = this.getCXFConfigFromDeployment(dep)) == null && PREFER_SPRING_DESCRIPTOR_GENERATION) {
            DDBeans dd = this.generateMetadataFromDeployment(dep);
            cxfURL = dd.createFileURL();
            log.debug((Object)("JBossWS-CXF configuration generated: " + cxfURL));
        }
        if (cxfURL == null) {
            this.generateMetadataFromDeployment(dep);
        } else {
            log.debug((Object)("Actual configuration from file: " + cxfURL));
            this.putCXFConfigToDeployment(dep, cxfURL);
        }
    }

    public void stop(Deployment dep) {
        DDBeans dd = (DDBeans)dep.getAttachment(DDBeans.class);
        if (dd != null) {
            dd.destroyFileURL();
        }
    }

    private URL getCXFConfigFromDeployment(Deployment dep) {
        if (WSHelper.isJaxrpcDeployment((Deployment)dep)) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_DEPLOYMENT_TYPE", (Object[])new Object[]{DeploymentType.JAXRPC}));
        }
        String metadir = null;
        metadir = WSHelper.isJseDeployment((Deployment)dep) || WSHelper.isWarArchive((Deployment)dep) ? "WEB-INF" : "META-INF";
        URL cxfURL = null;
        try {
            ArchiveDeployment archDep = (ArchiveDeployment)dep;
            cxfURL = archDep.getResourceResolver().resolve(metadir + "/" + "jbossws-cxf.xml");
            log.debug((Object)("JBossWS-CXF configuration found: " + cxfURL));
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return cxfURL;
    }

    private DDBeans generateMetadataFromDeployment(Deployment dep) {
        MetadataBuilder builder = new MetadataBuilder();
        DDBeans dd = builder.build(dep);
        dep.addAttachment(DDBeans.class, (Object)dd);
        return dd;
    }

    private void putCXFConfigToDeployment(Deployment dep, URL cxfURL) {
        HashMap<String, String> contextParams = (HashMap<String, String>)dep.getProperty("stack.context.parameters");
        if (contextParams == null) {
            contextParams = new HashMap<String, String>();
            dep.setProperty("stack.context.parameters", contextParams);
        }
        contextParams.put("jbossws.cxf.beans.url", cxfURL.toExternalForm());
    }
}

