/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/**
 * Created by The eXo Platform SARL
 * Author : Dang Van Minh
 *          minh.dang@exoplatform.com
 * Jan 25, 2007
 * 1:59:57 PM
 */
@ComponentConfig(
                 template = "app:/groovy/webui/component/explorer/UIViewMetadataContainer.gtmpl",
                 events = { @EventConfig(listeners = UIViewMetadataContainer.SelectTabActionListener.class)
})
public class UIViewMetadataContainer extends UITabPane {

  private boolean hasMoreOneMetaData;
  
  public UIViewMetadataContainer() throws Exception {
  }
  
  /**
   * @return the hasMoreOneMetaData
   */
  public boolean isHasMoreOneMetaData() {
    return hasMoreOneMetaData;
  }

  /**
   * @param hasMoreOneMetaData the hasMoreOneMetaData to set
   */
  public void setHasMoreOneMetaData(boolean hasMoreOneMetaData) {
    this.hasMoreOneMetaData = hasMoreOneMetaData;
  }
  
  public static class SelectTabActionListener extends EventListener<UITabPane> {
    public void execute(Event<UITabPane> event) throws Exception {
      WebuiRequestContext context = event.getRequestContext();
      String renderTab = context.getRequestParameter(UIComponent.OBJECTID);
      if (renderTab == null)
          return;
      event.getSource().setSelectedTab(renderTab);
      WebuiRequestContext parentContext = (WebuiRequestContext) context.getParentAppRequestContext();
      if (parentContext != null) {
          parentContext.setResponseComplete(true);
      } else {
          context.setResponseComplete(true);
      }
      
      event.getRequestContext().addUIComponentToUpdateByAjax(event.getSource());
    }
  }
}
