/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import com.google.inject.CreationException;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.PropertiesModule;
import org.exoplatform.portal.gadget.core.GateInContainerConfigLoader;
import org.exoplatform.portal.gadget.core.GateInGuiceServletContextListener;

public class ExoPropertiesModule
extends PropertiesModule {
    private static final String GTN_SHINDIG_PROPERTIES = "shindig.properties";
    private final Properties properties = this.readPropertyFile("shindig.properties");

    protected Properties getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        return super.getProperties();
    }

    private Properties readPropertyFile(String propertyFile) {
        Properties properties = null;
        InputStream is = null;
        try {
            GateInContainerConfigLoader currentLoader = GateInGuiceServletContextListener.getCurrentLoader();
            is = currentLoader.loadResourceAsStream(propertyFile);
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        }
        catch (IOException e) {
            try {
                throw new CreationException(Arrays.asList(new Message("Unable to load properties: " + propertyFile)));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return properties;
    }
}

