/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.rss;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.forum.rss.FeedContentProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FeedResolver {
    private static Log LOG = ExoLogger.getLogger(FeedResolver.class);
    private FeedContentProvider defaultProvider;
    private Map<String, String> providers;

    public FeedResolver() {
        this.providers = new HashMap<String, String>();
    }

    public FeedResolver(InitParams params) {
        try {
            String impl = params.getValueParam("defaultProvider").getValue();
            this.defaultProvider = this.instanciate(impl);
        }
        catch (Exception e) {
            LOG.error((Object)"failed to instanciate default provider", (Throwable)e);
        }
        PropertiesParam param = params.getPropertiesParam("providers");
        this.providers = param.getProperties();
    }

    private FeedContentProvider instanciate(String impl) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(impl);
            FeedContentProvider provider = (FeedContentProvider)clazz.newInstance();
            return provider;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FeedContentProvider resolve(String appType) {
        String impl = this.providers.get(appType);
        if (impl == null) {
            return this.defaultProvider;
        }
        FeedContentProvider provider = this.instanciate(impl);
        return provider;
    }

    public FeedContentProvider getDefaultProvider() {
        return this.defaultProvider;
    }

    public void setDefaultProvider(FeedContentProvider defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    public Map<String, String> getProviders() {
        return this.providers;
    }

    public void setProviders(Map<String, String> providers) {
        this.providers = providers;
    }
}

