/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.gagravarr.flac.FlacFirstOggPacket;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.vorbis.VorbisPacket;

public class OggDetector
implements Detector {
    public static final MediaType OGG_VIDEO = MediaType.video((String)"ogg");
    public static final MediaType OGG_GENERAL = MediaType.application((String)"ogg");
    public static final MediaType OGG_AUDIO = MediaType.audio((String)"ogg");
    public static final MediaType OGG_VORBIS = MediaType.audio((String)"vorbis");
    public static final MediaType FLAC = MediaType.audio((String)"x-flac");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(4);
        try {
            if (input.read() != 79 || input.read() != 103 || input.read() != 103 || input.read() != 83) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
        }
        finally {
            input.reset();
        }
        TikaInputStream tis = TikaInputStream.cast((InputStream)input);
        if (tis != null) {
            OggPacket p;
            tis.mark((int)tis.getLength() + 1);
            OggFile ogg = new OggFile((InputStream)tis);
            int streams = 0;
            int flacCount = 0;
            int vorbisCount = 0;
            ArrayList<Integer> sids = new ArrayList<Integer>();
            OggPacketReader r = ogg.getPacketReader();
            while ((p = r.getNextPacket()) != null) {
                if (!p.isBeginningOfStream()) continue;
                ++streams;
                sids.add(p.getSid());
                if (p.getData() == null || p.getData().length <= 10) continue;
                if (VorbisPacket.isVorbisStream((OggPacket)p)) {
                    ++vorbisCount;
                }
                if (!FlacFirstOggPacket.isFlacStream((OggPacket)p)) continue;
                ++flacCount;
            }
            tis.reset();
            if (vorbisCount == 1 && streams == 1) {
                return OGG_VORBIS;
            }
            if (flacCount == 1 && streams == 1) {
                return FLAC;
            }
            if (vorbisCount > 1 && vorbisCount == streams) {
                return OGG_VORBIS;
            }
            if (flacCount > 1 && flacCount == streams) {
                return FLAC;
            }
            if (streams <= 0) {
                return OGG_GENERAL;
            }
        }
        return OGG_GENERAL;
    }
}

